/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.keyboard;

import java.util.HashSet;
import java.util.Set;
import libsidplay.components.keyboard.KeyTableEntry;

public abstract class Keyboard {
    private final Set<KeyTableEntry> keysDown = new HashSet<KeyTableEntry>();

    public synchronized void reset() {
        this.keysDown.clear();
    }

    public synchronized void keyPressed(KeyTableEntry ktEntry) {
        this.keysDown.add(ktEntry);
    }

    public synchronized Set<KeyTableEntry> getKeysDown() {
        return this.keysDown;
    }

    public synchronized void keyReleased(KeyTableEntry ktEntry) {
        this.keysDown.remove((Object)ktEntry);
    }

    private synchronized byte readMatrix(byte selected, boolean wantRow) {
        byte result = -1;
        for (KeyTableEntry kte : this.keysDown) {
            if (wantRow) {
                if ((selected & 1 << kte.getCol()) != 0) continue;
                result = (byte)(result & ~(1 << kte.getRow()));
                continue;
            }
            if ((selected & 1 << kte.getRow()) != 0) continue;
            result = (byte)(result & ~(1 << kte.getCol()));
        }
        return result;
    }

    public byte readColumn(byte selected) {
        return this.readMatrix(selected, true);
    }

    public byte readRow(byte selected) {
        return this.readMatrix(selected, false);
    }

    public abstract void restore();
}

