/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.ScannerBuffer;
import java_cup.runtime.Symbol;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLElement {
    protected String tagname;

    public abstract List<XMLElement> selectById(String var1);

    public static void dump(XMLStreamWriter xMLStreamWriter, XMLElement xMLElement, String ... stringArray) throws XMLStreamException {
        XMLElement.dump(null, xMLStreamWriter, xMLElement, stringArray);
    }

    public static void dump(ScannerBuffer scannerBuffer, XMLStreamWriter xMLStreamWriter, XMLElement xMLElement, String ... stringArray) throws XMLStreamException {
        xMLStreamWriter.writeStartDocument("utf-8", "1.0");
        xMLStreamWriter.writeProcessingInstruction("xml-stylesheet", "href=\"tree.xsl\" type=\"text/xsl\"");
        xMLStreamWriter.writeStartElement("document");
        if (stringArray.length > 0) {
            xMLStreamWriter.writeStartElement("blacklist");
            for (String string : stringArray) {
                xMLStreamWriter.writeStartElement("symbol");
                xMLStreamWriter.writeCharacters(string);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("parsetree");
        xMLElement.dump(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
        if (scannerBuffer != null) {
            xMLStreamWriter.writeStartElement("tokensequence");
            for (Symbol symbol : scannerBuffer.getBuffered()) {
                if (symbol instanceof ComplexSymbolFactory.ComplexSymbol) {
                    ComplexSymbolFactory.ComplexSymbol complexSymbol = (ComplexSymbolFactory.ComplexSymbol)symbol;
                    if (complexSymbol.value != null) {
                        xMLStreamWriter.writeStartElement("token");
                        xMLStreamWriter.writeAttribute("name", complexSymbol.getName());
                        complexSymbol.getLeft().toXML(xMLStreamWriter, "left");
                        xMLStreamWriter.writeCharacters(complexSymbol.value + "");
                        complexSymbol.getRight().toXML(xMLStreamWriter, "right");
                        xMLStreamWriter.writeEndElement();
                        continue;
                    }
                    xMLStreamWriter.writeStartElement("keyword");
                    xMLStreamWriter.writeAttribute("left", complexSymbol.getLeft() + "");
                    xMLStreamWriter.writeAttribute("right", complexSymbol.getRight() + "");
                    xMLStreamWriter.writeCharacters(complexSymbol.getName() + "");
                    xMLStreamWriter.writeEndElement();
                    continue;
                }
                if (!(symbol instanceof Symbol)) continue;
                xMLStreamWriter.writeStartElement("token");
                xMLStreamWriter.writeCharacters(symbol.toString());
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.flush();
        xMLStreamWriter.close();
    }

    public abstract ComplexSymbolFactory.Location right();

    public abstract ComplexSymbolFactory.Location left();

    protected abstract void dump(XMLStreamWriter var1) throws XMLStreamException;

    public static class Terminal
    extends XMLElement {
        ComplexSymbolFactory.Location l;
        ComplexSymbolFactory.Location r;
        Object value;

        @Override
        public List<XMLElement> selectById(String string) {
            LinkedList<XMLElement> linkedList = new LinkedList<XMLElement>();
            if (this.tagname.equals(string)) {
                linkedList.add(this);
            }
            return linkedList;
        }

        public Terminal(ComplexSymbolFactory.Location location, String string, ComplexSymbolFactory.Location location2) {
            this(location, string, null, location2);
        }

        public Terminal(ComplexSymbolFactory.Location location, String string, Object object, ComplexSymbolFactory.Location location2) {
            this.l = location;
            this.r = location2;
            this.value = object;
            this.tagname = string;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            return this.l;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            return this.r;
        }

        public String toString() {
            return this.value == null ? "<terminal id=\"" + this.tagname + "\"/>" : "<terminal id=\"" + this.tagname + "\" left=\"" + this.l + "\" right=\"" + this.r + "\">" + this.value + "</terminal>";
        }

        @Override
        protected void dump(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            xMLStreamWriter.writeStartElement("terminal");
            xMLStreamWriter.writeAttribute("id", this.tagname);
            xMLStreamWriter.writeAttribute("left", this.left() + "");
            xMLStreamWriter.writeAttribute("right", this.right() + "");
            if (this.value != null) {
                xMLStreamWriter.writeCharacters(this.value + "");
            }
            xMLStreamWriter.writeEndElement();
        }
    }

    public static class Error
    extends XMLElement {
        ComplexSymbolFactory.Location l;
        ComplexSymbolFactory.Location r;

        @Override
        public List<XMLElement> selectById(String string) {
            return new LinkedList<XMLElement>();
        }

        public Error(ComplexSymbolFactory.Location location, ComplexSymbolFactory.Location location2) {
            this.l = location;
            this.r = location2;
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            return this.l;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            return this.r;
        }

        public String toString() {
            return "<error left=\"" + this.l + "\" right=\"" + this.r + "\"/>";
        }

        @Override
        protected void dump(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            xMLStreamWriter.writeStartElement("error");
            xMLStreamWriter.writeAttribute("left", this.left() + "");
            xMLStreamWriter.writeAttribute("right", this.right() + "");
            xMLStreamWriter.writeEndElement();
        }
    }

    public static class NonTerminal
    extends XMLElement {
        private int variant;
        LinkedList<XMLElement> list;

        @Override
        public List<XMLElement> selectById(String string) {
            LinkedList<XMLElement> linkedList = new LinkedList<XMLElement>();
            if (this.tagname.equals(string)) {
                linkedList.add(this);
            }
            for (XMLElement xMLElement : this.list) {
                List<XMLElement> list = xMLElement.selectById(string);
                linkedList.addAll(list);
            }
            return linkedList;
        }

        public NonTerminal(String string, int n, XMLElement ... xMLElementArray) {
            this.tagname = string;
            this.variant = n;
            this.list = new LinkedList<XMLElement>(Arrays.asList(xMLElementArray));
        }

        @Override
        public ComplexSymbolFactory.Location left() {
            for (XMLElement xMLElement : this.list) {
                ComplexSymbolFactory.Location location = xMLElement.left();
                if (location == null) continue;
                return location;
            }
            return null;
        }

        @Override
        public ComplexSymbolFactory.Location right() {
            Iterator<XMLElement> iterator = this.list.descendingIterator();
            while (iterator.hasNext()) {
                ComplexSymbolFactory.Location location = iterator.next().left();
                if (location == null) continue;
                return location;
            }
            return null;
        }

        public String toString() {
            if (this.list.isEmpty()) {
                return "<nonterminal id=\"" + this.tagname + "\" variant=\"" + this.variant + "\" />";
            }
            String string = "<nonterminal id=\"" + this.tagname + "\" left=\"" + this.left() + "\" right=\"" + this.right() + "\" variant=\"" + this.variant + "\">";
            for (XMLElement xMLElement : this.list) {
                string = string + xMLElement.toString();
            }
            return string + "</nonterminal>";
        }

        @Override
        protected void dump(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
            xMLStreamWriter.writeStartElement("nonterminal");
            xMLStreamWriter.writeAttribute("id", this.tagname);
            xMLStreamWriter.writeAttribute("variant", this.variant + "");
            ComplexSymbolFactory.Location location = this.left();
            if (location != null) {
                location.toXML(xMLStreamWriter, "left");
            }
            for (XMLElement xMLElement : this.list) {
                xMLElement.dump(xMLStreamWriter);
            }
            location = this.right();
            if (location != null) {
                location.toXML(xMLStreamWriter, "right");
            }
            xMLStreamWriter.writeEndElement();
        }
    }
}

