/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.IDiagnostic;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.segments.Segment;

public class AssertErrorCodeDirective
extends AsmDirective {
    private ExprNode testNameExpr;
    private AsmNode body;
    private List<IDiagnostic> errorsFound = null;
    boolean prepassed = false;

    public AssertErrorCodeDirective(ExprNode exprNode, AsmNode asmNode, SourceRange sourceRange) {
        super(sourceRange);
        this.testNameExpr = exprNode;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorCodeDirective(this.testNameExpr, this.body, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), null);
        this.body = new ScopeNode(this.body, symbolScope);
        evaluationState.diagnosticMgr.startExpectDiagnosticMode();
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.diagnosticMgr.endExpectDiagnosticMode();
        this.errorsFound = evaluationState.diagnosticMgr.getExpectedErrors();
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.testNameExpr.executePrepass(evaluationState);
        evaluationState.diagnosticMgr.startExpectDiagnosticMode();
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.diagnosticMgr.endExpectDiagnosticMode();
        this.errorsFound.addAll(evaluationState.diagnosticMgr.getExpectedErrors());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Segment segment = evaluationState.segmentMgr.getCurrentSegment();
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        int n = evaluationState.callStack.getStackSize();
        Segment segment2 = new Segment("AssertError", this.range);
        segment2.initPass();
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment2);
        IDiagnostic iDiagnostic = null;
        if (!this.errorsFound.isEmpty()) {
            iDiagnostic = this.errorsFound.get(0);
        } else {
            try {
                this.body = this.body.executePass(evaluationState);
            }
            catch (AsmErrorException asmErrorException) {
                iDiagnostic = asmErrorException.getError();
            }
        }
        evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        evaluationState.callStack.popTilDepth(n);
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.testNameExpr.evaluate(evaluationState);
        if (iDiagnostic == null && !this.body.isFinished()) {
            return this;
        }
        String string = value.getString(this.range);
        String string2 = iDiagnostic != null ? string + " -- OK. | " + iDiagnostic.getMessage() : string + " -- FAILED!";
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(iDiagnostic == null);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

