/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.nonasm.tools.StringTool;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;

public class AssertCodeDirective
extends AsmDirective {
    private ExprNode msgExpr;
    private AsmNode resultNode;
    private AsmNode expectedNode;
    private Segment expectedSegment;
    private Segment resultSegment;
    private boolean assertDone = false;

    public AssertCodeDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.resultNode = asmNode;
        this.expectedNode = asmNode2;
    }

    private AssertCodeDirective(AssertCodeDirective assertCodeDirective) {
        super(assertCodeDirective.range);
        this.msgExpr = assertCodeDirective.msgExpr;
        this.resultNode = assertCodeDirective.resultNode;
        this.expectedNode = assertCodeDirective.expectedNode;
        this.expectedSegment = assertCodeDirective.expectedSegment;
        this.resultSegment = assertCodeDirective.resultSegment;
    }

    @Override
    public AsmNode copy() {
        return new AssertCodeDirective(this);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, null);
        SymbolScope symbolScope3 = new SymbolScope(symbolScope, null);
        this.resultNode = new ScopeNode(this.resultNode, symbolScope2);
        this.expectedNode = new ScopeNode(this.expectedNode, symbolScope3);
        this.resultNode = this.resultNode.executeMetaRegistrations(evaluationState);
        this.expectedNode = this.expectedNode.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.resultNode = this.resultNode.executePrepass(evaluationState);
        this.expectedNode = this.expectedNode.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl;
        if (this.expectedSegment == null) {
            this.resultSegment = new Segment("Result", this.range);
            this.resultSegment.setAllowOverlappingMemoryBlocks(true);
            this.expectedSegment = new Segment("Expected", this.range);
            this.expectedSegment.setAllowOverlappingMemoryBlocks(true);
            evaluationState.setMadeMetaProgress();
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        this.resultSegment.initPass();
        this.expectedSegment.initPass();
        Segment segment = evaluationState.segmentMgr.getCurrentSegment();
        evaluationState.segmentMgr.switchToSegment(this.resultSegment);
        this.resultNode = this.resultNode.executePass(evaluationState);
        evaluationState.segmentMgr.switchToSegment(this.expectedSegment);
        this.expectedNode = this.expectedNode.executePass(evaluationState);
        evaluationState.segmentMgr.switchToSegment(segment);
        this.resultSegment.getCurrentMemoryBlock().closeForNewEntries();
        this.expectedSegment.getCurrentMemoryBlock().closeForNewEntries();
        Value value = this.msgExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        boolean bl3 = bl = this.resultNode.isFinished() && this.expectedNode.isFinished() && !bl2;
        if (!bl) {
            return this;
        }
        if (this.assertDone) {
            return this;
        }
        this.assertDone = true;
        this.resultSegment.close(evaluationState);
        boolean bl4 = this.resultSegment.finalize(evaluationState);
        this.expectedSegment.close(evaluationState);
        boolean bl5 = this.expectedSegment.finalize(evaluationState);
        if (bl4 || bl5) {
            return this;
        }
        String string = value.getString(this.range);
        boolean bl6 = this.resultSegment.flattenAreEqual(this.expectedSegment);
        String string2 = bl6 ? string + " -- OK. | " + this.codeToString(this.resultSegment) : string + " -- FAILED! | " + this.codeToString(this.resultSegment) + "  -- " + this.codeToString(this.expectedSegment);
        evaluationState.sideeffectMgr.addTextOutput(string2);
        evaluationState.assertMgr.madeAssert(!bl6);
        return this;
    }

    private String codeToString(Segment segment) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SegmentMemoryBlock segmentMemoryBlock : segment.getOutputMemoryBlocks()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("; ");
            }
            stringBuffer.append(StringTool.toHexString(segmentMemoryBlock.getStart(), 4));
            stringBuffer.append(":");
            boolean bl2 = true;
            for (byte by : segmentMemoryBlock.getBytes()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(StringTool.toHexString(by, 2));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isFinished() {
        return this.assertDone;
    }
}

