/*
 * Decompiled with CFR 0.152.
 */
package ui.toolbar;

import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import libsidplay.common.ChipModel;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.converter.EnumToStringConverter;
import ui.entities.config.DeviceMapping;

public class SidBlasterDeviceMapping
extends C64VBox
implements UIPart {
    @FXML
    private CheckBox usedCheckbox;
    @FXML
    private TextField serialNumEditor;
    @FXML
    private ComboBox<ChipModel> chipModelEditor;
    @FXML
    private ToggleButton testButton;
    private DeviceMapping deviceMapping;
    private BiConsumer<DeviceMapping, Boolean> testSidBlasterDeviceConsumer;
    private Consumer<DeviceMapping> removeSidBlasterDeviceConsumer;

    public SidBlasterDeviceMapping() {
    }

    public SidBlasterDeviceMapping(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        ResourceBundle bundle = this.util.getBundle();
        Pattern pattern = Pattern.compile("^$|" + bundle.getString("SIDBLASTER_SERIALNUM_FORMAT"));
        this.serialNumEditor.textProperty().addListener((obj, o, n) -> this.deviceMapping.setSerialNum((String)n));
        this.serialNumEditor.textProperty().addListener((obj, o, n) -> this.util.checkTextField(this.serialNumEditor, () -> pattern.matcher((CharSequence)n).find(), () -> {}, "SIDBLASTER_SERIALNUM_TIP", "SIDBLASTER_SERIALNUM_FORMAT"));
        this.chipModelEditor.setItems(FXCollections.observableArrayList((Object[])ChipModel.values()));
        this.chipModelEditor.setConverter(new EnumToStringConverter(bundle));
        this.chipModelEditor.valueProperty().addListener((obj, o, n) -> this.deviceMapping.setChipModel((ChipModel)((Object)n)));
    }

    @FXML
    private void setUsed() {
        this.deviceMapping.setUsed(this.usedCheckbox.isSelected());
    }

    @FXML
    private void remove() {
        this.removeSidBlasterDeviceConsumer.accept(this.deviceMapping);
    }

    @FXML
    private void testSidBlaster() {
        this.testSidBlasterDeviceConsumer.accept(this.deviceMapping, this.testButton.isSelected());
    }

    void init(DeviceMapping deviceMapping, BiConsumer<DeviceMapping, Boolean> testSidBlasterDeviceConsumer, Consumer<DeviceMapping> removeSidBlasterDeviceConsumer, ToggleGroup testButtonGroup) {
        this.deviceMapping = deviceMapping;
        this.testSidBlasterDeviceConsumer = testSidBlasterDeviceConsumer;
        this.removeSidBlasterDeviceConsumer = removeSidBlasterDeviceConsumer;
        this.getStyleClass().add((Object)"sidblaster-device");
        this.usedCheckbox.setSelected(deviceMapping.isUsed());
        this.serialNumEditor.setText(deviceMapping.getSerialNum());
        this.chipModelEditor.setValue((Object)Optional.ofNullable(deviceMapping.getChipModel()).orElse(ChipModel.MOS8580));
        this.testButton.setToggleGroup(testButtonGroup);
    }

    public String getSerialNo() {
        return this.serialNumEditor.getText();
    }
}

