/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoSockets;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Paths;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsNodePath;

@Immutable
final class TBIO {
    static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.checkContains(src, dst);
        if (dst.exists()) {
            throw new FileAlreadyExistsException(src.getPath(), dst.getPath(), null);
        }
        TBIO.mv0(src, dst, detector);
    }

    private static void mv0(File src, File dst, TArchiveDetector detector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstIsArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcIsArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstIsArchived && TConfig.current().isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new NotDirectoryException(dst.getPath());
            }
            Object[] members = src.list();
            if (null == members) {
                throw new FileSystemException(dst.getPath(), null, "Cannot list directory!");
            }
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.mv0(new TFile(src, (String)member, detector), new TFile(dst, (String)member, detector), detector);
            }
            if (!srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new FileSystemException(dst.getPath(), null, "Cannot set last modification time!");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new FileSystemException(dst.getPath(), null, "Not a file!");
            }
            TBIO.cp0(true, src, dst);
        } else {
            if (src.exists()) {
                throw new FileSystemException(src.getPath(), null, "Cannot move special file!");
            }
            throw new NoSuchFileException(src.getPath());
        }
        if (!src.delete()) {
            throw new FileSystemException(src.getPath(), null, "Cannot delete!");
        }
    }

    static void cp_r(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp_r0(preserve, src, dst, srcDetector, dstDetector);
    }

    private static void cp_r0(boolean preserve, File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcArchived = src instanceof TFile && null != ((TFile)src).getInnerArchive();
            boolean dstArchived = dst instanceof TFile && null != ((TFile)dst).getInnerArchive();
            boolean bl = srcIsGhost = srcArchived && 0L >= srcLastModified;
            if (!(srcIsGhost && dstArchived && TConfig.current().isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new NotDirectoryException(dst.getPath());
            }
            Object[] members = src.list();
            if (null == members) {
                throw new FileSystemException(dst.getPath(), null, "Cannot list directory!");
            }
            if (!srcArchived && dstArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                TBIO.cp_r0(preserve, new TFile(src, (String)member, srcDetector), new TFile(dst, (String)member, dstDetector), srcDetector, dstDetector);
            }
            if (preserve && !srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new FileSystemException(dst.getPath(), null, "Cannot set last modification time!");
            }
        } else if (src.isFile()) {
            if (dst.exists() && !dst.isFile()) {
                throw new FileSystemException(dst.getPath(), null, "Not a file!");
            }
            TBIO.cp0(preserve, src, dst);
        } else {
            if (src.exists()) {
                throw new FileSystemException(src.getPath(), null, "Cannot copy special file!");
            }
            throw new NoSuchFileException(src.getPath());
        }
    }

    static void cp(boolean preserve, File src, File dst) throws IOException {
        TBIO.checkContains(src, dst);
        TBIO.cp0(preserve, src, dst);
    }

    private static void cp0(boolean preserve, File src, File dst) throws IOException {
        BitField<FsAccessOption> preferences = TConfig.current().getAccessPreferences();
        InputSocket<?> input = TBIO.input(preferences, src);
        OutputSocket<?> output = TBIO.output(preferences, dst, preserve ? input.target() : null);
        IoSockets.copy(input, output);
    }

    static void rm_r(File file, TArchiveDetector detector) throws IOException {
        if (file.isDirectory()) {
            String[] members = file.list();
            if (null == members) {
                throw new FileSystemException(file.getPath(), null, "Cannot list directory!");
            }
            for (String member : members) {
                TBIO.rm_r(new TFile(file, member, detector), detector);
            }
        }
        TFile.rm(file);
    }

    private static void checkContains(File a, File b) throws IOException {
        if (Paths.contains((String)a.getAbsolutePath(), (String)b.getAbsolutePath(), (char)File.separatorChar)) {
            throw new FileSystemException(a.getPath(), b.getPath(), "First path contains second path!");
        }
    }

    private static TArchiveDetector detector(File file) {
        return file instanceof TFile ? ((TFile)file).getArchiveDetector() : TConfig.current().getArchiveDetector();
    }

    static InputSocket<?> input(BitField<FsAccessOption> options, File file) {
        TFile tfile;
        TFile archive;
        if (file instanceof TFile && null != (archive = (tfile = (TFile)file).getInnerArchive())) {
            return archive.getController().input(options, tfile.getNodeName());
        }
        FsNodePath path = new FsNodePath(file);
        return TConfig.current().getManager().controller((FsCompositeDriver)TBIO.detector(file), path.getMountPoint()).input(options, path.getNodeName());
    }

    static OutputSocket<?> output(BitField<FsAccessOption> options, File file, @CheckForNull Entry template) {
        TFile tfile;
        TFile archive;
        if (file instanceof TFile && null != (archive = (tfile = (TFile)file).getInnerArchive())) {
            return archive.getController().output(options, tfile.getNodeName(), template);
        }
        FsNodePath path = new FsNodePath(file);
        return TConfig.current().getManager().controller((FsCompositeDriver)TBIO.detector(file), path.getMountPoint()).output(options.clear((Enum)FsAccessOption.CREATE_PARENTS), path.getNodeName(), template);
    }

    private TBIO() {
    }
}

