/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import libsidplay.config.ISidPlay2Section;
import libsidplay.sidtune.SidTune;

public class PlayList {
    private ISidPlay2Section sidplay2Section;
    private SidTune tune;
    private int first;
    private int length;
    private int current;

    public PlayList(ISidPlay2Section sidplay2Section, SidTune tune, boolean firstPlayListEntryIsOne) {
        this.sidplay2Section = sidplay2Section;
        this.tune = tune;
        if (tune != SidTune.RESET) {
            this.current = tune.getInfo().getSelectedSong();
            this.length = sidplay2Section.isSingle() ? 1 : tune.getInfo().getSongs();
        } else {
            this.current = 1;
            this.length = 1;
        }
        this.first = firstPlayListEntryIsOne ? 1 : this.current;
    }

    public void prepare() {
        if (this.tune != SidTune.RESET) {
            this.tune.getInfo().setSelectedSong(this.current);
            this.tune.prepare();
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public int getTrackNum() {
        int start = this.current - this.first + 1;
        return start < 1 ? start + this.length : start;
    }

    public int getLength() {
        return this.length;
    }

    public void next() {
        this.current = this.getNext();
    }

    public void previous() {
        this.current = this.getPrevious();
    }

    public void first() {
        this.current = this.first;
    }

    public void last() {
        int last = this.sidplay2Section.isSingle() ? this.first : this.first - 1;
        this.current = last < 1 ? this.length : last;
    }

    public boolean hasPrevious() {
        return this.current != this.first;
    }

    public boolean hasNext() {
        return this.getNext() != this.first;
    }

    public int getPrevious() {
        int previous = this.sidplay2Section.isSingle() ? this.current : this.current - 1;
        return previous < 1 ? this.length : previous;
    }

    public int getNext() {
        int next = this.sidplay2Section.isSingle() ? this.current : this.current + 1;
        return next > this.length ? 1 : next;
    }
}

