/*
 * Decompiled with CFR 0.152.
 */
package builder.jsidblaster;

import libsidplay.common.ChipModel;

public enum SIDType {
    NONE,
    MOS6581,
    MOS8580;


    public ChipModel asChipModel() {
        switch (this.ordinal()) {
            case 1: {
                return ChipModel.MOS6581;
            }
            case 2: {
                return ChipModel.MOS8580;
            }
        }
        return ChipModel.AUTO;
    }

    public static SIDType to(sidblaster.SIDType hardSID_GetSIDType) {
        switch (hardSID_GetSIDType) {
            case MOS6581: {
                return MOS6581;
            }
            case MOS8580: {
                return MOS8580;
            }
        }
        return NONE;
    }

    public static sidblaster.SIDType from(SIDType sidType) {
        switch (sidType.ordinal()) {
            case 1: {
                return sidblaster.SIDType.MOS6581;
            }
            case 2: {
                return sidblaster.SIDType.MOS8580;
            }
        }
        return sidblaster.SIDType.NONE;
    }
}

