/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ClosedOutputException;
import net.java.truecommons.io.DecoratingOutputStream;

@NotThreadSafe
public abstract class DisconnectingOutputStream
extends DecoratingOutputStream {
    protected DisconnectingOutputStream() {
    }

    protected DisconnectingOutputStream(OutputStream out) {
        super(out);
    }

    public abstract boolean isOpen();

    protected final void checkOpen() throws ClosedOutputException {
        if (!this.isOpen()) {
            throw new ClosedOutputException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.checkOpen();
        this.out.flush();
    }

    @Override
    public abstract void close() throws IOException;
}

