/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class FillTailParser
implements ITailParser<AsmNode> {
    private Func3<ExprNode, List<ExprNode>, SourceRange, AsmNode> nodeCreator;

    public FillTailParser(Func3<ExprNode, List<ExprNode>, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        List<ExprNode> list;
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        TokenStreamList tokenStreamList2 = tokenStreamList.getUntilCommaSkipWsAndNl();
        if (!tokenStreamList2.getTerminatingToken().expectType(TokenType.Comma, evaluationState, "Comma seperator expected")) {
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList2, evaluationState);
        if (exprNode == null) {
            return null;
        }
        tokenStreamList.skipWs();
        if (tokenStreamList.peek().getType() == TokenType.SquareBracketRange) {
            IToken iToken2 = tokenStreamList.next();
            list = ExprParser.parseOptExprList(iToken2.getChildStream(), evaluationState);
            if (list == null) {
                return null;
            }
            tokenStreamList.skipWs();
            if (!tokenStreamList.peek().expectEos(evaluationState)) {
                return null;
            }
        } else {
            ExprNode exprNode2 = ExprParser.parse(tokenStreamList, evaluationState);
            if (exprNode2 == null) {
                return null;
            }
            list = new ArrayList<ExprNode>();
            list.add(exprNode2);
        }
        return this.nodeCreator.apply(exprNode, list, sourceRange);
    }
}

