/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import java.io.File;
import kickass.common.exceptions.NotImplementedException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.metanodes.AddRangeToCallStackNode;
import kickass.pass.asmnode.metanodes.NamespaceNode;
import kickass.pass.asmnode.metanodes.SetCurrentDirectoryNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.state.EvaluationState;

public class FileImportNode
extends AsmNode {
    private AsmNode body;
    private File newSourceDir;
    private SourceRange callRange;

    public FileImportNode(AsmNode asmNode, File file, SourceRange sourceRange) {
        this.body = asmNode;
        this.callRange = sourceRange;
        this.newSourceDir = file;
    }

    @Override
    public AsmNode copy() {
        return new FileImportNode(this.body, this.newSourceDir, this.callRange);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        AsmNode asmNode = new AddRangeToCallStackNode(this.callRange, this.body);
        asmNode = new SetCurrentDirectoryNode(this.newSourceDir, asmNode);
        asmNode = new NamespaceNode(asmNode, evaluationState.namespaceMgr.getRootNamespace());
        return asmNode.executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public String toString() {
        return "FileImport";
    }
}

