/*
 * Decompiled with CFR 0.152.
 */
package kickass.plugins.impl;

import java.io.File;
import java.io.OutputStream;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.plugins.impl.PluginMemoryBlock;
import kickass.plugins.interf.general.IEngine;
import kickass.plugins.interf.general.IMemoryBlock;
import kickass.plugins.interf.general.ISourceRange;
import kickass.state.EvaluationState;

public class PluginEngine
implements IEngine {
    private EvaluationState state;
    private SourceRange callSourceRange;

    public PluginEngine(EvaluationState evaluationState, SourceRange sourceRange) {
        this.state = evaluationState;
        this.callSourceRange = sourceRange;
    }

    @Override
    public File getFile(String string) {
        return this.state.fileMgr.getFile(string, false);
    }

    @Override
    public void print(String string) {
        this.state.sideeffectMgr.addTextOutput(string);
    }

    @Override
    public File getCurrentDirectory() {
        return this.state.fileMgr.getCurrentDirectory();
    }

    @Override
    public void printNow(String string) {
        this.state.log.println(string);
    }

    @Override
    public void error(String string) {
        throw new AsmErrorException(string, this.callSourceRange);
    }

    @Override
    public void error(String string, ISourceRange iSourceRange) {
        throw new AsmErrorException(string, (SourceRange)iSourceRange);
    }

    @Override
    public void addError(String string, ISourceRange iSourceRange) {
        this.state.diagnosticMgr.add(new AsmError(string, (SourceRange)iSourceRange));
    }

    @Override
    public IMemoryBlock createMemoryBlock(String string, int n, byte[] byArray) {
        return new PluginMemoryBlock(string, n, byArray);
    }

    @Override
    public byte charToByte(char c) {
        return CharToPetsciiConverter.convertOrChar(c, CharToPetsciiConverter.charToPetscii_upper);
    }

    @Override
    public byte[] stringToBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = this.charToByte(string.charAt(i));
        }
        return byArray;
    }

    @Override
    public OutputStream openOutputStream(String string) throws Exception {
        return this.state.outputMgr.OpenOutputStream(string, true);
    }

    @Override
    public String normalizeFileName(String string) {
        return this.state.c64OutputMgr.NormalizeFilename(string);
    }
}

