/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.d2xx;

import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import java.util.ArrayList;
import java.util.List;
import sidblaster.ISIDBlaster;
import sidblaster.ISIDBlasterEnumerator;
import sidblaster.SIDBlaster;
import sidblaster.d2xx.D2XXManager;

public class SIDBlasterEnumerator
implements ISIDBlasterEnumerator {
    private List<FTDevice> devices;
    private List<Boolean> devicesAllocated;
    private static SIDBlasterEnumerator INSTANCE = new SIDBlasterEnumerator();

    public static SIDBlasterEnumerator getInstance() {
        return INSTANCE;
    }

    @Override
    public int deviceCount() throws FTD2XXException {
        D2XXManager manager = D2XXManager.getInstance();
        manager.rescan();
        this.devices = new ArrayList<FTDevice>();
        this.devicesAllocated = new ArrayList<Boolean>();
        for (int i = 0; i < manager.count(); ++i) {
            this.devices.add(manager.getDevice(i));
            this.devicesAllocated.add(false);
        }
        return this.devices.size();
    }

    @Override
    public ISIDBlaster createInterface(int deviceID) {
        if (deviceID < this.devices.size()) {
            assert (!this.devicesAllocated.get(deviceID).booleanValue());
            FTDevice sid = this.devices.get(deviceID);
            this.devicesAllocated.set(deviceID, true);
            return new SIDBlaster(deviceID, sid);
        }
        return null;
    }

    @Override
    public void releaseInterface(ISIDBlaster sidblaster) {
        if (sidblaster.deviceID() < this.devices.size()) {
            this.devicesAllocated.set(sidblaster.deviceID(), false);
        }
    }
}

