/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resid;

import builder.resid.ReSIDBase;
import builder.resid.resid.Filter6581;
import builder.resid.resid.Filter8580;
import builder.resid.resid.SID;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDChip;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IFilterSection;

public class ReSID
extends ReSIDBase {
    private SID sidImpl;

    public ReSID(EventScheduler context) {
        super(context);
    }

    @Override
    protected SIDChip createSID() {
        this.sidImpl = new SID();
        return this.sidImpl;
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        boolean enable = emulation.isFilterEnable(sidNum);
        switch (this.sidImpl.getChipModel()) {
            case MOS6581: {
                this.sidImpl.getFilter6581().enable(enable);
                break;
            }
            case MOS8580: {
                this.sidImpl.getFilter8580().enable(enable);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SID chip model: " + (Object)((Object)this.sidImpl.getChipModel()));
            }
        }
    }

    @Override
    public void setFilter(IConfig config, int sidNum) {
        IEmulationSection emulationSection = config.getEmulationSection();
        switch (this.sidImpl.getChipModel()) {
            case MOS6581: {
                String filterName6581 = emulationSection.getFilterName(sidNum, Engine.EMULATION, Emulation.RESID, ChipModel.MOS6581);
                if (filterName6581 == null) {
                    return;
                }
                Filter6581 filter6581 = this.sidImpl.getFilter6581();
                for (IFilterSection iFilterSection : config.getFilterSection()) {
                    if (!iFilterSection.isReSIDFilter6581() || !iFilterSection.getName().equals(filterName6581)) continue;
                    filter6581.setFilterCurve(iFilterSection.getFilter6581CurvePosition());
                    return;
                }
                throw new RuntimeException("Filter name not found: " + filterName6581);
            }
            case MOS8580: {
                String filterName8580 = emulationSection.getFilterName(sidNum, Engine.EMULATION, Emulation.RESID, ChipModel.MOS8580);
                if (filterName8580 == null) {
                    return;
                }
                Filter8580 filter8580 = this.sidImpl.getFilter8580();
                for (IFilterSection iFilterSection : config.getFilterSection()) {
                    if (!iFilterSection.isReSIDFilter8580() || !iFilterSection.getName().equals(filterName8580) || !iFilterSection.isReSIDFilter8580()) continue;
                    filter8580.setFilterCurve(iFilterSection.getFilter8580CurvePosition());
                    return;
                }
                throw new RuntimeException("Filter name not found: " + filterName8580);
            }
        }
        throw new RuntimeException("Unknown SID chip model: " + (Object)((Object)this.sidImpl.getChipModel()));
    }

    @Override
    public byte readENV(int voiceNum) {
        return this.sidImpl.voice[voiceNum].envelope.readENV();
    }

    @Override
    public byte readOSC(int voiceNum) {
        return this.sidImpl.voice[voiceNum].wave.readOSC(this.sidImpl.getChipModel());
    }

    public static String credits() {
        String credit = "MOS6581/8580 (SID) - Dag Lem's resid 1.0 beta:\n";
        credit = credit + "\tCopyright (\u00a9) 1999-2012 Dag Lem <resid@nimrod.no>\n";
        credit = credit + "\tCopyright (\u00a9) 2012 Java version by Antti S. Lankila <alankila@bel.fi>\n";
        return credit;
    }

    public static class FakeStereo
    extends ReSID {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<ReSIDBase> sids;

        public FakeStereo(EventScheduler context, IConfig config, int prevNum, List<ReSIDBase> sids) {
            super(context);
            this.emulationSection = config.getEmulationSection();
            this.prevNum = prevNum;
            this.sids = sids;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

