/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import libsidplay.components.c1541.G64;
import libsidplay.components.c1541.GCR;
import libsidplay.components.c1541.Rotation;

public class NIB
extends G64 {
    static final String IMAGE_HEADER = "MNIB-1541-RAW";
    private static final int MNIB_TRACK_LENGTH = 8192;
    private static final int MATCH_LENGTH = 7;
    private static final int MIN_TRACK_LENGTH = 6016;
    private byte[] nibHeader = new byte[256];
    private byte[] trackData = new byte[7928];
    private byte[] mnibTrackData = new byte[8192];
    private static int[] speed_map_1541 = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public NIB(GCR gcr, String fileName, RandomAccessFile fd, boolean readOnly) {
        super(gcr, fileName, fd, readOnly);
    }

    @Override
    protected void attach() throws IOException {
        this.fd.readFully(this.nibHeader);
        if (!new String(this.nibHeader, "ISO-8859-1").startsWith(IMAGE_HEADER)) {
            throw new IOException(String.format("GCR image is not MNIB-1541-RAW format.", new Object[0]));
        }
        this.tracks = 42;
        int[] trackOffsets = new int[84];
        int[] speedZoneOffsets = new int[84];
        for (int track = 0; track < 42; ++track) {
            trackOffsets[track * 2] = 684 + track * 7930;
            trackOffsets[track * 2 + 1] = 0;
            speedZoneOffsets[track * 2] = this.nibHeader[17 + track * 2] & 3;
            speedZoneOffsets[track * 2 + 1] = 0;
        }
        int trackDataPos = 0;
        int headerOffset = 16;
        for (int track = 0; track < 42; ++track) {
            Arrays.fill(this.trackData, (byte)-1);
            if (this.nibHeader[headerOffset] < track + 1 << 1) {
                this.fd.seek(this.fd.getFilePointer() + 8192L);
                headerOffset += 2;
            }
            headerOffset += 2;
            try {
                this.fd.readFully(this.mnibTrackData);
            }
            catch (IOException ioE) {
                int trackLen;
                Arrays.fill(this.trackData, (byte)85);
                this.trackData[0] = -1;
                this.trackSize[track] = trackLen = Rotation.ROT_SPEED_BPC[speed_map_1541[track]] / 40;
                this.gcr.setTrackData(this.trackData, trackDataPos, trackLen);
                trackDataPos += trackLen;
                continue;
            }
            int trackLen = this.extractGCRtrack(this.trackData, this.mnibTrackData);
            if (trackLen == 0) {
                trackLen = Rotation.ROT_SPEED_BPC[speed_map_1541[track]] / 40;
                Arrays.fill(this.trackData, (byte)85);
                this.trackData[0] = -1;
            } else if (trackLen > 7928) {
                System.err.printf("  Warning: track too long, cropping to %d!", 7928);
                trackLen = 7928;
            }
            this.trackSize[track] = trackLen;
            this.gcr.setTrackData(this.trackData, trackDataPos, 7928);
            trackDataPos += 7928;
        }
    }

    private int extractGCRtrack(byte[] dest, byte[] src) {
        TrackCycle cycle = new TrackCycle(0, 0);
        this.findTrackCycle(src, cycle);
        int trackLen = cycle.cycleStop - cycle.cycleStart;
        if (trackLen == 0) {
            return 0;
        }
        byte[] gcrData = new byte[16384];
        System.arraycopy(src, cycle.cycleStart, gcrData, 0, trackLen);
        System.arraycopy(src, cycle.cycleStart, gcrData, trackLen, trackLen);
        int sectorGapPos = this.findSectorGap(gcrData, trackLen);
        if (-1 != sectorGapPos) {
            System.arraycopy(gcrData, sectorGapPos, dest, 0, trackLen);
        } else {
            int sector0Pos = this.findSector0(gcrData, trackLen);
            if (-1 != sector0Pos) {
                System.arraycopy(gcrData, sector0Pos, dest, 0, trackLen);
            } else {
                System.arraycopy(gcrData, 0, dest, 0, trackLen);
            }
        }
        return trackLen;
    }

    private int findTrackCycle(byte[] gcrData, TrackCycle cycle) {
        int nibTrack = cycle.cycleStart;
        int stopPos = nibTrack + 8192 - 7;
        int startPos = nibTrack;
        while (true) {
            int syncPos;
            if ((syncPos = startPos + 6016) >= stopPos) {
                cycle.cycleStop = cycle.cycleStart;
                return 0;
            }
            while ((syncPos = this.findSync(gcrData, syncPos, stopPos)) != -1) {
                int cycle_pos;
                int p1 = startPos;
                int p2 = cycle_pos = syncPos;
                while (p2 < stopPos) {
                    if (!this.equals(gcrData, p1, p2, 7)) {
                        cycle_pos = -1;
                        break;
                    }
                    if ((p1 = this.findSync(gcrData, p1, stopPos)) != -1 && (p2 = this.findSync(gcrData, p2, stopPos)) != -1) continue;
                }
                if (cycle_pos == -1) continue;
                cycle.cycleStart = startPos;
                cycle.cycleStop = cycle_pos;
                return cycle_pos - startPos;
            }
            if ((startPos = this.findSync(gcrData, startPos, stopPos)) != -1) continue;
            startPos = stopPos;
        }
    }

    private boolean equals(byte[] gcrData, int from, int to, int length) {
        for (int i = 0; i < length; ++i) {
            if (gcrData[from + i] == gcrData[to + i]) continue;
            return false;
        }
        return true;
    }

    private int findSector0(byte[] gcrData, int tracklen) {
        int pos = 0;
        int bufferEnd = 2 * tracklen - 10;
        while (pos < bufferEnd) {
            if ((pos = this.findSync(gcrData, pos, bufferEnd)) == -1) {
                return -1;
            }
            if (gcrData[pos + 0] != 82 || (gcrData[pos + 1] & 0xC0) != 64 || (gcrData[pos + 2] & 0xF) != 5 || (gcrData[pos + 3] & 0xFC) != 40) continue;
        }
        do {
            if (--pos != 0) continue;
            pos += tracklen;
        } while (gcrData[pos] == -1);
        ++pos;
        while (pos >= tracklen) {
            pos -= tracklen;
        }
        return pos;
    }

    private int findSync(byte[] gcrData, int pos, int gcrEnd) {
        while (true) {
            if (pos + 1 >= gcrEnd) {
                pos = gcrEnd;
                return -1;
            }
            if ((gcrData[pos + 0] & 3) == 3 && gcrData[pos + 1] == -1) break;
            ++pos;
        }
        ++pos;
        while (pos < gcrEnd && gcrData[pos] == -1) {
            ++pos;
        }
        return pos < gcrEnd ? pos : -1;
    }

    private int findSectorGap(byte[] gcrData, int tracklen) {
        int syncMax = 0;
        int pos = 0;
        int bufferEnd = (tracklen << 1) - 10;
        if ((pos = this.findSync(gcrData, pos, bufferEnd)) == -1) {
            return -1;
        }
        int syncLast = pos;
        int maxgap = 0;
        while (pos < bufferEnd && (pos = this.findSync(gcrData, pos, bufferEnd)) != -1) {
            int gap = pos - syncLast;
            if (gap > maxgap) {
                maxgap = gap;
                syncMax = pos;
            }
            syncLast = pos;
        }
        if (maxgap == 0) {
            return -1;
        }
        pos = syncMax;
        do {
            if (--pos != 0) continue;
            pos += tracklen;
        } while (gcrData[pos] == -1);
        ++pos;
        while (pos >= tracklen) {
            pos -= tracklen;
        }
        return pos;
    }

    @Override
    public void gcrDataWriteback(int track) throws IOException {
        System.err.println("Writing to nib files is not supported!");
    }

    private static class TrackCycle {
        int cycleStart;
        int cycleStop;

        public TrackCycle(int start, int stop) {
            this.cycleStart = start;
            this.cycleStop = stop;
        }
    }
}

