/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;
import libsidutils.IOUtils;

public class REU
extends Cartridge {
    private static final int REGISTER_STATUS = 0;
    private static final int REGISTER_COMMAND = 1;
    private static final int REGISTER_BASEADDR_LOW = 2;
    private static final int REGISTER_BASEADDR_HIGH = 3;
    private static final int REGISTER_RAMADDR_LOW = 4;
    private static final int REGISTER_RAMADDR_HIGH = 5;
    private static final int REGISTER_BANK = 6;
    private static final int REGISTER_BLOCKLEN_LOW = 7;
    private static final int REGISTER_BLOCKLEN_HIGH = 8;
    private static final int REGISTER_INTERRUPT = 9;
    private static final int REGISTER_ADDR_CONTROL = 10;
    private static final int REGISTER_INTERRUPT_UNUSED = 31;
    private static final int REGISTER_ADDR_CONTROL_UNUSED = 63;
    protected static int wrapAround;
    protected boolean dmaActive;
    protected byte[] ram;
    protected boolean ba;
    protected boolean ff00;
    protected byte status;
    protected byte command;
    protected byte interrupt;
    protected byte addrControl;
    protected int baseAddr;
    protected int shadowBaseAddr;
    protected int ramAddr;
    protected int shadowRamAddr;
    protected short dmaLen;
    protected short shadowDmaLen;
    protected Command reuOperation;
    protected final DMAEvent dmaEvent;
    protected final Event dmaBeginEvent;
    protected final Event dmaEndEvent;
    private final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            if (REU.this.dmaActive) {
                return REU.this.pla.getDisconnectedBusBank().read(address);
            }
            switch (address &= 0x1F) {
                case 0: {
                    byte value = REU.this.status;
                    REU.this.status = (byte)(REU.this.status & 0x1F);
                    REU.this.interrupt();
                    return value;
                }
                case 1: {
                    return REU.this.command;
                }
                case 3: {
                    return (byte)(REU.this.baseAddr >> 8);
                }
                case 2: {
                    return (byte)REU.this.baseAddr;
                }
                case 5: {
                    return (byte)(REU.this.ramAddr >> 8);
                }
                case 4: {
                    return (byte)REU.this.ramAddr;
                }
                case 6: {
                    return (byte)(REU.this.ramAddr >> 16);
                }
                case 8: {
                    return (byte)(REU.this.dmaLen >> 8);
                }
                case 7: {
                    return (byte)REU.this.dmaLen;
                }
                case 9: {
                    byte value = REU.this.interrupt;
                    value = (byte)(value | 0x1F);
                    return value;
                }
                case 10: {
                    byte value = REU.this.addrControl;
                    value = (byte)(value | 0x3F);
                    return value;
                }
            }
            return -1;
        }

        @Override
        public void write(int address, byte value) {
            if (REU.this.dmaActive) {
                return;
            }
            switch (address &= 0x1F) {
                case 0: {
                    return;
                }
                case 1: {
                    REU.this.command = value;
                    REU.this.reuOperation = Command.values()[value & 3];
                    boolean bl = REU.this.ff00 = (value & 0x90) == 128;
                    if ((value & 0x90) == 144) {
                        REU.this.beginDma();
                    }
                    return;
                }
                case 3: {
                    REU.this.shadowBaseAddr &= 0xFF;
                    REU.this.shadowBaseAddr |= (value & 0xFF) << 8;
                    REU.this.baseAddr = REU.this.shadowBaseAddr;
                    return;
                }
                case 2: {
                    REU.this.shadowBaseAddr &= 0xFF00;
                    REU.this.shadowBaseAddr |= value & 0xFF;
                    REU.this.baseAddr = REU.this.shadowBaseAddr;
                    return;
                }
                case 5: {
                    REU.this.shadowRamAddr &= 0xFF00FF;
                    REU.this.shadowRamAddr |= (value & 0xFF) << 8;
                    REU.this.ramAddr &= wrapAround & 0xFF0000;
                    REU.this.ramAddr |= REU.this.shadowRamAddr & 0xFFFF;
                    REU.this.ramAddr &= wrapAround;
                    return;
                }
                case 4: {
                    REU.this.shadowRamAddr &= 0xFFFF00;
                    REU.this.shadowRamAddr |= value & 0xFF;
                    REU.this.ramAddr &= wrapAround & 0xFF0000;
                    REU.this.ramAddr |= REU.this.shadowRamAddr & 0xFFFF;
                    REU.this.ramAddr &= wrapAround;
                    return;
                }
                case 6: {
                    REU.this.ramAddr &= 0xFFFF;
                    REU.this.ramAddr |= (value & 0xFF) << 16;
                    REU.this.ramAddr &= wrapAround;
                    REU.this.shadowRamAddr &= 0xFFFF;
                    REU.this.shadowRamAddr |= (value & 0xFF) << 16;
                    return;
                }
                case 8: {
                    REU.this.shadowDmaLen = (short)(REU.this.shadowDmaLen & 0xFF);
                    REU.this.dmaLen = REU.this.shadowDmaLen = (short)(REU.this.shadowDmaLen | (value & 0xFF) << 8);
                    return;
                }
                case 7: {
                    REU.this.shadowDmaLen = (short)(REU.this.shadowDmaLen & 0xFF00);
                    REU.this.dmaLen = REU.this.shadowDmaLen = (short)(REU.this.shadowDmaLen | value & 0xFF);
                    return;
                }
                case 9: {
                    REU.this.interrupt = value;
                    REU.this.interrupt();
                    return;
                }
                case 10: {
                    REU.this.addrControl = value;
                    return;
                }
            }
        }
    };

    protected void interrupt() {
        int irq = 0x60 & this.interrupt & this.status;
        if (irq != 0 && (this.interrupt & 0x80) != 0) {
            this.status = (byte)(this.status | 0x80);
        }
        this.setIRQ((this.status & 0x80) != 0);
    }

    public REU(DataInputStream dis, PLA pla, int sizeKB) throws IOException {
        super(pla);
        if (dis == null) assert (sizeKB == 0 || sizeKB == 128 || sizeKB == 512 || sizeKB == 256 || sizeKB == 2048 || sizeKB == 16384);
        if (sizeKB == 0) {
            sizeKB = 16384;
        }
        this.dmaEvent = new DMAEvent();
        this.dmaBeginEvent = Event.of("REU DMA Begin", event -> {
            pla.setDMA(true);
            this.dmaActive = true;
            this.dmaEvent.reset();
            if (this.ba) {
                pla.getCPU().getEventScheduler().schedule(this.dmaEvent, 0L, Event.Phase.PHI2);
            }
        });
        this.dmaEndEvent = Event.of("REU DMA End", event -> {
            this.dmaActive = false;
            pla.setDMA(false);
        });
        wrapAround = (sizeKB << 10) - 1;
        this.ram = new byte[sizeKB << 10];
        Arrays.fill(this.ram, (byte)0);
        if (dis != null) {
            try {
                dis.readFully(this.ram);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        this.reset();
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.status = (byte)16;
        this.command = (byte)16;
        this.shadowBaseAddr = 0;
        this.baseAddr = 0;
        this.shadowRamAddr = 0;
        this.ramAddr = 0;
        this.shadowDmaLen = (short)-1;
        this.dmaLen = (short)-1;
        this.interrupt = 0;
        this.addrControl = 0;
        this.dmaActive = false;
    }

    @Override
    public void changedBA(boolean state) {
        this.ba = state;
        if (!this.dmaActive) {
            return;
        }
        if (this.ba) {
            this.pla.getCPU().getEventScheduler().schedule(this.dmaEvent, 0L, Event.Phase.PHI2);
        } else {
            this.pla.getCPU().getEventScheduler().cancel(this.dmaEvent);
        }
    }

    @Override
    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
        final Bank rom = cpuWriteMap[15];
        cpuWriteMap[15] = new Bank(){

            @Override
            public void write(int address, byte value) {
                rom.write(address, value);
                if (REU.this.ff00 && address == 65280) {
                    REU.this.ff00 = false;
                    REU.this.beginDma();
                }
            }
        };
    }

    protected void beginDma() {
        this.pla.getCPU().getEventScheduler().schedule(this.dmaBeginEvent, 0L, Event.Phase.PHI1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getModelName() + " (" + IOUtils.getPhysicalSize(this.ram.length) + ")";
    }

    private String getModelName() {
        switch (this.ram.length >> 10) {
            case 128: {
                return "1700";
            }
            case 512: {
                return "1750";
            }
            case 256: {
                return "1764";
            }
            case 2048: {
                return "1750XL";
            }
        }
        return "<noname>";
    }

    protected class DMAEvent
    extends Event {
        private boolean swapReadPhase;
        private byte swapData;
        private int verifyError;

        protected DMAEvent() {
            super("REU DMA Active");
        }

        protected void reset() {
            this.swapReadPhase = true;
            this.verifyError = 0;
        }

        protected void finish() {
            REU.this.command = (byte)(REU.this.command & 0x7F);
            REU.this.command = (byte)(REU.this.command | 0x10);
            if ((REU.this.command & 0x20) != 0) {
                REU.this.baseAddr = REU.this.shadowBaseAddr;
                REU.this.ramAddr = wrapAround & REU.this.shadowRamAddr;
                REU.this.dmaLen = REU.this.shadowDmaLen;
            }
            REU.this.pla.getCPU().getEventScheduler().schedule(REU.this.dmaEndEvent, 0L, Event.Phase.PHI1);
        }

        @Override
        public void event() {
            int oldVerifyError = this.verifyError++;
            switch (REU.this.reuOperation.ordinal()) {
                case 0: {
                    REU.this.ram[REU.this.ramAddr] = REU.this.pla.cpuRead(REU.this.baseAddr);
                    break;
                }
                case 1: {
                    REU.this.pla.cpuWrite(REU.this.baseAddr, REU.this.ram[REU.this.ramAddr]);
                    break;
                }
                case 2: {
                    if (this.swapReadPhase) {
                        this.swapReadPhase = false;
                        this.swapData = REU.this.pla.cpuRead(REU.this.baseAddr);
                        REU.this.pla.getCPU().getEventScheduler().schedule(this, 1L, Event.Phase.PHI2);
                        return;
                    }
                    this.swapReadPhase = true;
                    REU.this.pla.cpuWrite(REU.this.baseAddr, REU.this.ram[REU.this.ramAddr]);
                    REU.this.ram[REU.this.ramAddr] = this.swapData;
                    break;
                }
                case 3: {
                    if (REU.this.pla.cpuRead(REU.this.baseAddr) == REU.this.ram[REU.this.ramAddr]) break;
                    REU.this.status = (byte)(REU.this.status | 0x20);
                    REU.this.interrupt();
                }
            }
            if (oldVerifyError == 0) {
                if ((REU.this.addrControl & 0x80) == 0) {
                    REU.this.baseAddr = REU.this.baseAddr + 1 & 0xFFFF;
                }
                if ((REU.this.addrControl & 0x40) == 0) {
                    REU.this.ramAddr = REU.this.ramAddr + 1 & wrapAround;
                }
            }
            if (REU.this.dmaLen != 1) {
                REU.this.dmaLen = (short)(REU.this.dmaLen - 1);
                if (oldVerifyError == 0) {
                    REU.this.pla.getCPU().getEventScheduler().schedule(this, 1L, Event.Phase.PHI2);
                } else {
                    this.finish();
                }
            } else {
                if (this.verifyError != 2) {
                    REU.this.status = (byte)(REU.this.status | 0x40);
                    REU.this.interrupt();
                }
                this.finish();
            }
        }
    }

    private static enum Command {
        TO_REU,
        FROM_REU,
        SWAP,
        VERIFY;

    }
}

