/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.oscilloscope;

import libsidplay.C64;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.SIDEmu;

public abstract class OscilloscopeUtil {
    private C64 c64;
    private HighResolutionEvent highResolutionEvent;
    private long lastTime;
    private long ticksPerFrame;

    public OscilloscopeUtil(C64 c64) {
        this.c64 = c64;
        this.highResolutionEvent = new HighResolutionEvent();
    }

    protected abstract void updateGauges(Integer var1, SIDEmu var2);

    public void start(double fps) {
        if (!this.c64.getEventScheduler().isPending(this.highResolutionEvent)) {
            this.prepareHighResolutionEvent(fps);
            this.c64.getEventScheduler().scheduleThreadSafe(this.highResolutionEvent);
        }
    }

    public void stop() {
        this.c64.getEventScheduler().scheduleThreadSafe(Event.of("Cancel High Resolution SID Register Sampler", e -> this.c64.getEventScheduler().cancel(this.highResolutionEvent)));
    }

    private void prepareHighResolutionEvent(double fps) {
        this.lastTime = this.c64.getEventScheduler().getTime(Event.Phase.PHI2);
        CPUClock cpuClock = this.c64.getClock();
        this.ticksPerFrame = (long)(cpuClock.getCpuFrequency() / fps);
    }

    protected abstract void sampleGauges(Integer var1, SIDEmu var2, boolean var3);

    private class HighResolutionEvent
    extends Event {
        private int repaint;

        public HighResolutionEvent() {
            super("High Resolution SID Register Sampler");
        }

        @Override
        public void event() {
            long time = OscilloscopeUtil.this.c64.getEventScheduler().getTime(Event.Phase.PHI2);
            boolean addFrameImage = time - OscilloscopeUtil.this.lastTime >= OscilloscopeUtil.this.ticksPerFrame;
            OscilloscopeUtil.this.c64.configureSIDs((chipNum, sid) -> {
                sid.clock();
                OscilloscopeUtil.this.sampleGauges((Integer)chipNum, (SIDEmu)sid, (this.repaint & 0x7F) == 0);
                if (addFrameImage) {
                    OscilloscopeUtil.this.updateGauges((Integer)chipNum, (SIDEmu)sid);
                }
            });
            if (addFrameImage) {
                OscilloscopeUtil.this.lastTime += OscilloscopeUtil.this.ticksPerFrame;
            }
            ++this.repaint;
            OscilloscopeUtil.this.c64.getEventScheduler().schedule(OscilloscopeUtil.this.highResolutionEvent, 128L);
        }
    }
}

