/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.hls;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.converter.FractionSecondsToMsConverter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;

@WebServlet(name="OnKeepAliveServlet", displayName="OnKeepAliveServlet", urlPatterns={"/static/on_keep_alive"}, description="Keep alive video stream")
public class OnKeepAliveServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            OnKeepAliveServletParameters servletParameters = new OnKeepAliveServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            UUID uuid = servletParameters.getUuid();
            Long currentTime = servletParameters.getCurrentTime();
            Long bufferedEnd = servletParameters.getBufferedEnd();
            PlayerCleanupTimerTask.update(uuid, playerWithStatus -> playerWithStatus.onKeepAlive(currentTime, bufferedEnd));
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.hls.OnKeepAliveServletParameters")
    public static class OnKeepAliveServletParameters
    extends VideoRequestParamServletParameters {
        private Long currentTime;
        private Long bufferedEnd;

        public Long getCurrentTime() {
            return this.currentTime;
        }

        @Parameter(names={"--currentTime"}, converter=FractionSecondsToMsConverter.class, descriptionKey="CURRENT_TIME", order=-2147483646)
        public void setCurrentTime(Long currentTime) {
            this.currentTime = currentTime;
        }

        public Long getBufferedEnd() {
            return this.bufferedEnd;
        }

        @Parameter(names={"--bufferedEnd"}, converter=FractionSecondsToMsConverter.class, descriptionKey="BUFFERED_END", order=-2147483645)
        public void setBufferedEnd(Long bufferedEnd) {
            this.bufferedEnd = bufferedEnd;
        }
    }
}

