/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.sidmapping;

import builder.jhardsid.JHardSIDMapping;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import sidplay.ini.IniConfig;

@WebServlet(name="HardSIDMappingServlet", displayName="HardSIDMappingServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/hardsid-mapping/*"}, description="Get HardSID 4U, HardSID UPlay and HardSID Uno SID mapping information")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class HardSIDMappingServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.HardSIDMappingServlet.MAX_HARDSIDMAPPING_IN_PARALLEL, new DefaultThreadFactory("/hardsidmapping"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.HardSIDMappingServlet.HARDSIDMAPPING_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        HardSIDMappingServletParameters servletParameters = new HardSIDMappingServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(HardSIDMappingServlet.this.configuration, HardSIDMappingServlet.this.directoryProperties, parser, HardSIDMappingServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        IEmulationSection emulationSection = servletParameters.emulationSection;
                        Integer chipCount = servletParameters.getChipCount();
                        SidTune tune = SidTune.load(file);
                        Map<Integer, String> result = JHardSIDMapping.mapping(emulationSection, tune, chipCount);
                        if (!this.isComplete()) {
                            HardSIDMappingServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(HardSIDMappingServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        HardSIDMappingServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.sidmapping.HardSIDMappingServletParameters")
    public static class HardSIDMappingServletParameters
    extends FileRequestPathServletParameters {
        private Integer chipCount = 1;
        @ParametersDelegate
        private IEmulationSection emulationSection = new IniConfig().getEmulationSection();

        public Integer getChipCount() {
            return this.chipCount;
        }

        @Parameter(names={"--chipCount"}, descriptionKey="CHIP_COUNT", required=true, order=-2147483645)
        public void setChipCount(Integer chipCount) {
            this.chipCount = chipCount;
        }
    }
}

