/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IAudioSection;
import libsidplay.config.IAudioSystemProperties;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class ThrottlingDriver
implements AudioDriver {
    private static final Logger THROTTLING_DRIVER = Logger.getLogger(ThrottlingDriver.class.getName());
    private CPUClock cpuClock;
    private EventScheduler context;
    private long startTime;
    private long time;
    private long startC64Time;
    private long c64Time;
    private volatile Long clientTime;
    private volatile Long bufferedEnd;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.cpuClock = cpuClock;
        this.context = context;
        AudioConfig cfg = new AudioConfig(audioSection);
        this.startTime = 0L;
        this.time = 0L;
        this.startC64Time = 0L;
        this.c64Time = 0L;
        this.clientTime = null;
        this.bufferedEnd = null;
        this.sampleBuffer = ByteBuffer.allocateDirect(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        long gap;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
            this.startC64Time = this.context.getTime(Event.Phase.PHI2);
        }
        this.time = System.currentTimeMillis() - this.startTime + 4000L;
        this.c64Time = (long)((double)(this.context.getTime(Event.Phase.PHI2) - this.startC64Time) / this.cpuClock.getCpuFrequency() * 1000.0);
        long l = gap = this.clientTime != null && this.bufferedEnd != null ? this.bufferedEnd - this.clientTime : this.c64Time - this.time;
        if (gap > (long)IAudioSystemProperties.MAX_TIME_GAP) {
            long sleepTime = Math.min(gap - (long)IAudioSystemProperties.MAX_TIME_GAP, IAudioSystemProperties.SLEEP_DRIVER_SLEEP_TIME);
            if (THROTTLING_DRIVER.isLoggable(Level.FINE)) {
                THROTTLING_DRIVER.fine(String.format("time=%s, clientTime=%s, c64Time=%s, gap=%s, sleepTime=%s", this.millisToDate(this.time), this.millisToDate(this.clientTime), this.millisToDate(this.c64Time), this.millisToDate(gap), this.millisToDate(sleepTime)));
            }
            Thread.sleep(sleepTime);
        }
    }

    public void setClientTime(Long clientTime, Long bufferedEnd) {
        this.clientTime = clientTime;
        this.bufferedEnd = bufferedEnd;
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    private String millisToDate(Long millis) {
        if (millis == null) {
            return "???";
        }
        return new SimpleDateFormat("mm:ss:SSS").format(new Date(millis));
    }
}

