/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.xml.bind.annotation.XmlTransient;
import libsidplay.common.ChipModel;
import libsidplay.config.IDeviceMapping;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.ShadowField;

@Entity
@Access(value=AccessType.PROPERTY)
public class DeviceMapping
implements IDeviceMapping {
    private Integer id;
    private ShadowField<BooleanProperty, Boolean> used = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, false);
    private ShadowField<StringProperty, String> serialNum = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<ObjectProperty<ChipModel>, ChipModel> chipModel = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);

    public DeviceMapping() {
    }

    public DeviceMapping(DeviceMapping deviceMapping) {
        this(deviceMapping.getSerialNum(), deviceMapping.getChipModel(), deviceMapping.isUsed());
    }

    public DeviceMapping(IDeviceMapping deviceMapping) {
        this(deviceMapping.getSerialNum(), deviceMapping.getChipModel(), true);
    }

    public DeviceMapping(String serialNum, ChipModel chipModel, boolean used) {
        this.setSerialNum(serialNum);
        this.setChipModel(chipModel);
        this.setUsed(used);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public boolean isUsed() {
        return this.used.get();
    }

    @Override
    public void setUsed(boolean used) {
        this.used.set(used);
    }

    public final BooleanProperty usedProperty() {
        return this.used.property();
    }

    @Override
    public String getSerialNum() {
        return this.serialNum.get();
    }

    @Override
    public void setSerialNum(String serialNum) {
        this.serialNum.set(serialNum);
    }

    public final StringProperty serialNumberProperty() {
        return this.serialNum.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public ChipModel getChipModel() {
        return this.chipModel.get();
    }

    @Override
    public void setChipModel(ChipModel chipModel) {
        this.chipModel.set(chipModel);
    }

    public final ObjectProperty<ChipModel> chipModelProperty() {
        return this.chipModel.property();
    }

    public String toString() {
        return BeanToStringConverter.toString(this);
    }
}

