/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.io.DecoratingInputStream;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.access.TBIO;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;

@Immutable
public final class TFileInputStream
extends DecoratingInputStream {
    @CreatesObligation
    public TFileInputStream(String path) throws IOException {
        this(new TFile(path));
    }

    @CreatesObligation
    public TFileInputStream(String path, FsAccessOption ... options) throws IOException {
        this((File)new TFile(path), options);
    }

    @CreatesObligation
    public TFileInputStream(File file) throws IOException {
        this(file, (BitField<FsAccessOption>)FsAccessOptions.NONE);
    }

    @CreatesObligation
    public TFileInputStream(File file, FsAccessOption ... options) throws IOException {
        this(file, (BitField<FsAccessOption>)FsAccessOptions.of((FsAccessOption[])options));
    }

    @CreatesObligation
    public TFileInputStream(File file, BitField<FsAccessOption> options) throws IOException {
        super(TBIO.input((BitField<FsAccessOption>)TConfig.current().getAccessPreferences().or(options), file).stream(null));
    }
}

