/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.util.ExportFilter;
import com.healthmarketscience.jackcess.util.SimpleExportFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ExportUtil {
    public static final String DEFAULT_DELIMITER = ",";
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final String DEFAULT_FILE_EXT = "csv";

    private ExportUtil() {
    }

    public static void exportAll(Database db, File dir) throws IOException {
        ExportUtil.exportAll(db, dir, DEFAULT_FILE_EXT);
    }

    public static void exportAll(Database db, File dir, String ext) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db, File dir, String ext, boolean header) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), header, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db, File dir, String ext, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        for (String tableName : db.getTableNames()) {
            ExportUtil.exportFile(db, tableName, new File(dir, tableName + "." + ext), header, delim, quote, filter);
        }
    }

    public static void exportFile(Database db, String tableName, File f) throws IOException {
        ExportUtil.exportFile(db, tableName, f, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(Database db, String tableName, File f, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            ExportUtil.exportWriter(db, tableName, out, header, delim, quote, filter);
            out.close();
        }
        catch (Throwable throwable) {
            ByteUtil.closeQuietly(out);
            throw throwable;
        }
        ByteUtil.closeQuietly(out);
    }

    public static void exportWriter(Database db, String tableName, BufferedWriter out) throws IOException {
        ExportUtil.exportWriter(db, tableName, out, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    public static void exportWriter(Database db, String tableName, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        ExportUtil.exportWriter(CursorBuilder.createCursor(db.getTable(tableName)), out, header, delim, quote, filter);
    }

    public static void exportWriter(Cursor cursor, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        Row row;
        String delimiter = delim == null ? DEFAULT_DELIMITER : delim;
        Pattern needsQuotePattern = Pattern.compile("(?:" + Pattern.quote(delimiter) + ")|(?:" + Pattern.quote("" + quote) + ")|(?:[\n\r])");
        List<? extends Column> origCols = cursor.getTable().getColumns();
        List<Column> columns = new ArrayList<Column>(origCols);
        columns = filter.filterColumns(columns);
        HashSet<String> columnNames = null;
        if (!origCols.equals(columns)) {
            columnNames = new HashSet<String>();
            for (Column c : columns) {
                columnNames.add(c.getName());
            }
        }
        if (header) {
            Iterator<Column> iter = columns.iterator();
            while (iter.hasNext()) {
                ExportUtil.writeValue(out, iter.next().getName(), quote, needsQuotePattern);
                if (!iter.hasNext()) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        Object[] unfilteredRowData = new Object[columns.size()];
        while ((row = cursor.getNextRow(columnNames)) != null) {
            for (int i = 0; i < columns.size(); ++i) {
                unfilteredRowData[i] = columns.get(i).getRowValue(row);
            }
            Object[] rowData = filter.filterRow(unfilteredRowData);
            if (rowData == null) continue;
            for (int i = 0; i < columns.size(); ++i) {
                Object obj = rowData[i];
                if (obj != null) {
                    String value = null;
                    value = obj instanceof byte[] ? ByteUtil.toHexString((byte[])obj) : String.valueOf(rowData[i]);
                    ExportUtil.writeValue(out, value, quote, needsQuotePattern);
                }
                if (i >= columns.size() - 1) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        out.flush();
    }

    private static void writeValue(BufferedWriter out, String value, char quote, Pattern needsQuotePattern) throws IOException {
        if (!needsQuotePattern.matcher(value).find()) {
            out.write(value);
            return;
        }
        out.write(quote);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == quote) {
                out.write(quote);
            }
            out.write(c);
        }
        out.write(quote);
    }

    public static class Builder {
        private Database _db;
        private String _tableName;
        private String _ext = "csv";
        private Cursor _cursor;
        private String _delim = ",";
        private char _quote = (char)34;
        private ExportFilter _filter = SimpleExportFilter.INSTANCE;
        private boolean _header;

        public Builder(Database db) {
            this(db, null);
        }

        public Builder(Database db, String tableName) {
            this._db = db;
            this._tableName = tableName;
        }

        public Builder(Cursor cursor) {
            this._cursor = cursor;
        }

        public Builder setDatabase(Database db) {
            this._db = db;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setCursor(Cursor cursor) {
            this._cursor = cursor;
            return this;
        }

        public Builder setDelimiter(String delim) {
            this._delim = delim;
            return this;
        }

        public Builder setQuote(char quote) {
            this._quote = quote;
            return this;
        }

        public Builder setFilter(ExportFilter filter) {
            this._filter = filter;
            return this;
        }

        public Builder setHeader(boolean header) {
            this._header = header;
            return this;
        }

        public Builder setFileNameExtension(String ext) {
            this._ext = ext;
            return this;
        }

        public void exportAll(File dir) throws IOException {
            ExportUtil.exportAll(this._db, dir, this._ext, this._header, this._delim, this._quote, this._filter);
        }

        public void exportFile(File f) throws IOException {
            ExportUtil.exportFile(this._db, this._tableName, f, this._header, this._delim, this._quote, this._filter);
        }

        public void exportWriter(BufferedWriter writer) throws IOException {
            if (this._cursor != null) {
                ExportUtil.exportWriter(this._cursor, writer, this._header, this._delim, this._quote, this._filter);
            } else {
                ExportUtil.exportWriter(this._db, this._tableName, writer, this._header, this._delim, this._quote, this._filter);
            }
        }
    }
}

