/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class RandomAccessFileInStream
implements IInStream {
    private final RandomAccessFile randomAccessFile;

    public RandomAccessFileInStream(RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    public synchronized long seek(long l, int n) throws SevenZipException {
        try {
            switch (n) {
                case 0: {
                    this.randomAccessFile.seek(l);
                    break;
                }
                case 1: {
                    this.randomAccessFile.seek(this.randomAccessFile.getFilePointer() + l);
                    break;
                }
                case 2: {
                    this.randomAccessFile.seek(this.randomAccessFile.length() + l);
                    break;
                }
                default: {
                    throw new RuntimeException("Seek: unknown origin: " + n);
                }
            }
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error while seek operation", iOException);
        }
    }

    public synchronized int read(byte[] byArray) throws SevenZipException {
        try {
            int n = this.randomAccessFile.read(byArray);
            if (n == -1) {
                return 0;
            }
            return n;
        }
        catch (IOException iOException) {
            throw new SevenZipException("Error reading random access file", iOException);
        }
    }

    public synchronized void close() throws IOException {
        this.randomAccessFile.close();
    }
}

