/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kickass.common.diagnostics.AsmError;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.common.syntaxinfo.SyntaxType;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokens.SubFileToken;
import kickass.parsing.baselang.tokens.TokenUtil;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.BracketScopeDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.FileImportNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class MainParser
implements IDirectiveParser<AsmNode> {
    private Map<String, Map<String, ITailParser<AsmNode>>> cpuToMnemonics = new HashMap<String, Map<String, ITailParser<AsmNode>>>();
    private Map<String, ITailParser<AsmNode>> mnemonicSubParsers;
    private Map<String, ITailParser<AsmNode>> subParsers = new HashMap<String, ITailParser<AsmNode>>();
    private IDirectiveParser<AsmNode> scopeNodeParser;
    private BiFunction<String, SourceRange, AsmNode> labelNodeCreator;
    private BiFunction<String, SourceRange, AsmNode> multiLabelNodeCreator;
    private Func3<String, List<ExprNode>, SourceRange, AsmNode> macroExecNodeCreator;
    private ITailParser<AsmNode> pseudoCmdParser;
    private ITailParser<AsmNode> starParser;

    public void setCpusMnemonics(Map<String, Map<String, ITailParser<AsmNode>>> map) {
        this.cpuToMnemonics = map;
    }

    public boolean setCpu(String string) {
        if (!this.cpuToMnemonics.containsKey(string)) {
            return false;
        }
        this.mnemonicSubParsers = this.cpuToMnemonics.get(string);
        return true;
    }

    public MainParser setScopeNodeParser(IDirectiveParser<AsmNode> iDirectiveParser) {
        this.scopeNodeParser = iDirectiveParser;
        return this;
    }

    public void setMacroExecNodeCreator(Func3<String, List<ExprNode>, SourceRange, AsmNode> func3) {
        this.macroExecNodeCreator = func3;
    }

    public void setPseudoCmdExecNodeCreator(ITailParser<AsmNode> iTailParser) {
        this.pseudoCmdParser = iTailParser;
    }

    public void setStarParser(ITailParser<AsmNode> iTailParser) {
        this.starParser = iTailParser;
    }

    public void setLabelCreator(BiFunction<String, SourceRange, AsmNode> biFunction) {
        this.labelNodeCreator = biFunction;
    }

    public void setMultiLabelCreator(BiFunction<String, SourceRange, AsmNode> biFunction) {
        this.multiLabelNodeCreator = biFunction;
    }

    public void addSubPaser(String string, ITailParser<AsmNode> iTailParser) {
        this.subParsers.put(string, iTailParser);
    }

    @Override
    public AsmNode parse(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        return this.parse(iTokenStream, evaluationState, true);
    }

    public AsmNode parse(ITokenStream iTokenStream, EvaluationState evaluationState, boolean bl) throws IOException {
        boolean bl2;
        boolean bl3;
        IToken iToken = iTokenStream.nextSkipWsAndNl();
        if (iToken.isEos()) {
            return null;
        }
        TokenType tokenType = iToken.getType();
        TokenType tokenType2 = iTokenStream.peek().getType();
        if (tokenType == TokenType.Id) {
            if (tokenType2 == TokenType.Colon) {
                SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iTokenStream.next().getSourceRange());
                evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.label, sourceRange));
                return this.labelNodeCreator.apply(iToken.getStringValue(), sourceRange);
            }
            if (tokenType2 == TokenType.ParanthesisRange) {
                String string = iToken.getStringValue();
                evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.macroExecution, iToken.getSourceRange()));
                return this.parseMacroExecution(string, iToken.getSourceRange(), iTokenStream, evaluationState);
            }
            ITailParser<AsmNode> iTailParser = this.mnemonicSubParsers.get(iToken.getStringValue());
            if (iTailParser != null) {
                return iTailParser.parse(iToken, iToken.getSourceRange(), iTokenStream, evaluationState);
            }
            ITailParser<AsmNode> iTailParser2 = this.subParsers.get(iToken.getStringValue());
            if (iTailParser2 != null) {
                return iTailParser2.parse(iToken, iToken.getSourceRange(), iTokenStream, evaluationState);
            }
            return this.pseudoCmdParser.parse(iToken, iToken.getSourceRange(), iTokenStream, evaluationState);
        }
        boolean bl4 = bl3 = tokenType == TokenType.Dot && tokenType2 == TokenType.Id;
        if (bl3) {
            IToken iToken2 = iTokenStream.next();
            SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iToken2.getSourceRange());
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.directive, sourceRange));
            ITailParser<AsmNode> iTailParser = this.subParsers.get("." + iToken2.getStringValue());
            if (iTailParser == null) {
                evaluationState.diagnosticMgr.add(new AsmError("Invalid directive", sourceRange));
                iTokenStream.getUntilSemiOrNl();
                return null;
            }
            return iTailParser.parse(iToken2, sourceRange, iTokenStream, evaluationState);
        }
        boolean bl5 = bl2 = tokenType == TokenType.CurlyBracketRange;
        if (bl2) {
            AsmNodeList asmNodeList = new AsmNodeList(this.scopeNodeParser.parseAll(iToken.getChildStream(), evaluationState));
            if (!bl) {
                return asmNodeList;
            }
            return new BracketScopeDirective(asmNodeList);
        }
        if (tokenType == TokenType.Not) {
            IToken iToken3;
            String string = "!";
            if (tokenType2 == TokenType.Id) {
                string = "!" + iTokenStream.next().getStringValue();
            }
            if ((iToken3 = iTokenStream.expectType(TokenType.Colon, evaluationState)) == null) {
                return null;
            }
            SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iToken3.getSourceRange());
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.label, sourceRange));
            return this.multiLabelNodeCreator.apply(string, sourceRange);
        }
        if ((tokenType == TokenType.Times || tokenType == TokenType.TimesEqual) && this.starParser != null) {
            evaluationState.syntaxInfoMgr.add(new SyntaxInfo(SyntaxType.directive, iToken.getSourceRange()));
            return this.starParser.parse(iToken, iToken.getSourceRange(), iTokenStream, evaluationState);
        }
        if (tokenType == TokenType.Semi) {
            return null;
        }
        if (tokenType == TokenType.Colon && tokenType2 == TokenType.Id) {
            IToken iToken4 = iTokenStream.next();
            String string = iToken4.getStringValue();
            tokenType2 = iTokenStream.peek().getType();
            SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iToken4.getSourceRange());
            if (tokenType2 == TokenType.ParanthesisRange) {
                return this.parseMacroExecution(string, sourceRange, iTokenStream, evaluationState);
            }
            return this.pseudoCmdParser.parse(iToken4, sourceRange, iTokenStream, evaluationState);
        }
        if (tokenType == TokenType.SubFileToken) {
            File file = ((SubFileToken)iToken).getFile();
            List<AsmNode> list = this.parseAll(iToken.getChildStream(), evaluationState);
            return new FileImportNode(new AsmNodeList(list), file.getParentFile(), iToken.getSourceRange());
        }
        return this.handleError(iToken, iTokenStream, evaluationState);
    }

    private AsmNode handleError(IToken iToken, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        evaluationState.diagnosticMgr.add(new AsmError("Invalid token", iToken.getSourceRange()));
        iTokenStream.getUntilSemiOrNl();
        return null;
    }

    private AsmNode parseMacroExecution(String string, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        IToken iToken = tokenStreamList.next();
        TokenStreamList tokenStreamList2 = iToken.getChildStream();
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList2, evaluationState);
        if (list == null) {
            return null;
        }
        TokenUtil.addErrorOnExtraTokens(tokenStreamList, evaluationState);
        return this.macroExecNodeCreator.apply(string, list, sourceRange);
    }

    @Override
    public List<AsmNode> parseAll(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        return this.parseAll(iTokenStream, evaluationState, true);
    }

    public List<AsmNode> parseAll(ITokenStream iTokenStream, EvaluationState evaluationState, boolean bl) throws IOException {
        ArrayList<AsmNode> arrayList = new ArrayList<AsmNode>();
        AsmNode asmNode = null;
        while (!iTokenStream.peek().isEos()) {
            AsmNode asmNode2 = this.parse(iTokenStream, evaluationState, bl);
            if (asmNode2 != null) {
                arrayList.add(asmNode2);
                if (asmNode != null && asmNode2 instanceof ILabelConnectorNode) {
                    ILabelConnectorNode iLabelConnectorNode = (ILabelConnectorNode)((Object)asmNode2);
                    iLabelConnectorNode.connectToLabel((ILabelNode)((Object)asmNode));
                }
            }
            asmNode = asmNode2 instanceof ILabelNode ? asmNode2 : null;
        }
        return arrayList;
    }
}

