/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.NotImplementedException;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.ScopeValue;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class BracketScopeDirective
extends Directive
implements ILabelConnectorNode {
    private AsmNode body;
    private String nameSpaceId;

    public BracketScopeDirective(AsmNode asmNode) {
        super(null);
        this.body = asmNode;
    }

    private BracketScopeDirective(AsmNode asmNode, String string) {
        super(null);
        this.nameSpaceId = string;
        this.body = asmNode;
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.nameSpaceId = iLabelNode.getName();
        return true;
    }

    @Override
    public AsmNode copy() {
        return new BracketScopeDirective(this.body.copy(), this.nameSpaceId);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        SymbolScope symbolScope2 = new SymbolScope(symbolScope, null);
        ScopeNode scopeNode = new ScopeNode(this.body, symbolScope2);
        if (this.nameSpaceId != null) {
            ISymbolPageIdx iSymbolPageIdx = symbolScope.get(this.nameSpaceId);
            if (evaluationState.getZeropageFlag()) {
                iSymbolPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeValue(symbolScope2, iValueHolderArray), true)));
            } else {
                iSymbolPageIdx.replaceInitializer(iValueHolderArray -> new ConstantValueHolder(new LabelValue(new ScopeValue(symbolScope2, iValueHolderArray), false)));
            }
        }
        return ((AsmNode)scopeNode).executeMetaRegistrations(evaluationState);
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new NotImplementedException();
    }
}

