/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.io.File;
import java.util.List;
import kickass.AssemblerToolbox;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.FileImportNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.expressions.expr.Constant;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.StringValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ImportSourceDirective
extends AsmDirective {
    private List<ExprNode> argumentExprs;

    public ImportSourceDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.argumentExprs.size() != 1) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments. Import source takes exactly one argument", this.range));
            return EmptyOutput.instance;
        }
        ExprNode exprNode = this.argumentExprs.get(0);
        String string = this.getStringConstant(exprNode, evaluationState);
        if (string == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Import source must be given a string constant as argument", exprNode.getSourceRange()));
            return EmptyOutput.instance;
        }
        File file = evaluationState.fileMgr.getFile(string, true);
        if (file == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't open file: " + string, this.range));
            return EmptyOutput.instance;
        }
        if (evaluationState.fileMgr.isFileExcludedForImport(file)) {
            return EmptyOutput.instance;
        }
        AsmNode asmNode = AssemblerToolbox.loadAndLexOrError(string, evaluationState, this.range);
        if (asmNode == null) {
            return EmptyOutput.instance;
        }
        File file2 = file.getParentFile();
        asmNode = new FileImportNode(asmNode, file2, this.range);
        return asmNode.executeMetaRegistrations(evaluationState);
    }

    private String getStringConstant(ExprNode exprNode, EvaluationState evaluationState) {
        if (!(exprNode instanceof Constant)) {
            return null;
        }
        Value value = exprNode.evaluate(evaluationState);
        return value instanceof StringValue ? value.getString(null) : null;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        throw new ShouldNotBeHereException();
    }
}

