/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.sync;

import com.ftdi.FTD2XXException;
import java.util.ArrayList;
import java.util.List;
import sidblaster.Command;
import sidblaster.ICommandDispatcher;
import sidblaster.ISIDBlaster;
import sidblaster.d2xx.SIDBlasterEnumerator;

public class SyncDispatcher
implements ICommandDispatcher {
    private List<ISIDBlaster> m_SIDBlasters = new ArrayList<ISIDBlaster>();

    @Override
    public int sendCommand(Command cmd) throws FTD2XXException, InterruptedException {
        if (cmd.getDevice() >= 0 && cmd.getDevice() < this.m_SIDBlasters.size()) {
            ISIDBlaster sidblaster = this.m_SIDBlasters.get(cmd.getDevice());
            switch (cmd.getCommand()) {
                case Write: {
                    sidblaster.write(cmd.getReg(), cmd.getData());
                    break;
                }
                case Delay: {
                    if (cmd.getDelay() <= 0L) break;
                    Thread.sleep(cmd.getDelay());
                    break;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void initialize() throws FTD2XXException {
        int i;
        int deviceID = 0;
        int deviceCount = SIDBlasterEnumerator.getInstance().deviceCount();
        for (i = 0; i < deviceCount; ++i) {
            this.m_SIDBlasters.add(SIDBlasterEnumerator.getInstance().createInterface(deviceID++));
        }
        for (i = 0; i < this.m_SIDBlasters.size(); ++i) {
            this.m_SIDBlasters.get(i).open();
        }
    }

    @Override
    public void uninitialize() throws FTD2XXException {
        for (int i = 0; i < this.m_SIDBlasters.size(); ++i) {
            this.m_SIDBlasters.get(i).close();
            SIDBlasterEnumerator.getInstance().releaseInterface(this.m_SIDBlasters.get(i));
        }
        this.m_SIDBlasters.clear();
    }

    @Override
    public int deviceCount() {
        return this.m_SIDBlasters.size();
    }

    @Override
    public void setWriteBufferSize(int bufferSize) {
    }

    @Override
    public void setLatencyTimer(short ms) {
    }
}

