/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import client.teavm.common.IImportedApi;
import client.teavm.common.oscilloscope.EnvelopeGauge;
import client.teavm.common.oscilloscope.FilterGauge;
import client.teavm.common.oscilloscope.FrequencyGauge;
import client.teavm.common.oscilloscope.ResonanceGauge;
import client.teavm.common.oscilloscope.VolumeGauge;
import client.teavm.common.oscilloscope.WaveGauge;
import java.util.function.Function;
import libsidplay.C64;
import libsidplay.common.Mixer;
import libsidplay.common.SIDEmu;
import libsidutils.oscilloscope.OscilloscopeUtil;

public class Oscilloscope {
    public static final int MAX_OSCILLOSCOPE_SIDS = 3;
    private OscilloscopeUtil oscilloscopeUtil;
    private WaveGauge[] wav0 = new WaveGauge[3];
    private WaveGauge[] wav1 = new WaveGauge[3];
    private WaveGauge[] wav2 = new WaveGauge[3];
    private EnvelopeGauge[] env0 = new EnvelopeGauge[3];
    private EnvelopeGauge[] env1 = new EnvelopeGauge[3];
    private EnvelopeGauge[] env2 = new EnvelopeGauge[3];
    private FrequencyGauge[] frq0 = new FrequencyGauge[3];
    private FrequencyGauge[] frq1 = new FrequencyGauge[3];
    private FrequencyGauge[] frq2 = new FrequencyGauge[3];
    private VolumeGauge[] vol = new VolumeGauge[3];
    private ResonanceGauge[] res = new ResonanceGauge[3];
    private FilterGauge[] fil = new FilterGauge[3];
    private int fastForwardVICFrames;

    public Oscilloscope(final IImportedApi importedApi, C64 c64, final Mixer mixer, Function<String, String> localizer, int width, int height) {
        int pathLength = 1 + width * 3 * 4;
        for (int i = 0; i < 3; ++i) {
            int chipNum = i;
            this.wav0[i] = new WaveGauge(width, height, 0, localizer, () -> importedApi.initGaugeBuffer("wav0", chipNum, pathLength));
            this.wav1[i] = new WaveGauge(width, height, 1, localizer, () -> importedApi.initGaugeBuffer("wav1", chipNum, pathLength));
            this.wav2[i] = new WaveGauge(width, height, 2, localizer, () -> importedApi.initGaugeBuffer("wav2", chipNum, pathLength));
            this.env0[i] = new EnvelopeGauge(width, height, 0, localizer, () -> importedApi.initGaugeBuffer("env0", chipNum, pathLength));
            this.env1[i] = new EnvelopeGauge(width, height, 1, localizer, () -> importedApi.initGaugeBuffer("env1", chipNum, pathLength));
            this.env2[i] = new EnvelopeGauge(width, height, 2, localizer, () -> importedApi.initGaugeBuffer("env2", chipNum, pathLength));
            this.frq0[i] = new FrequencyGauge(width, height, 0, localizer, () -> importedApi.initGaugeBuffer("frq0", chipNum, pathLength));
            this.frq1[i] = new FrequencyGauge(width, height, 1, localizer, () -> importedApi.initGaugeBuffer("frq1", chipNum, pathLength));
            this.frq2[i] = new FrequencyGauge(width, height, 2, localizer, () -> importedApi.initGaugeBuffer("frq2", chipNum, pathLength));
            this.vol[i] = new VolumeGauge(width, height, localizer, () -> importedApi.initGaugeBuffer("vol", chipNum, pathLength));
            this.res[i] = new ResonanceGauge(width, height, localizer, () -> importedApi.initGaugeBuffer("res", chipNum, pathLength));
            this.fil[i] = new FilterGauge(width, height, localizer, () -> importedApi.initGaugeBuffer("fil", chipNum, pathLength));
        }
        this.oscilloscopeUtil = new OscilloscopeUtil(c64){

            @Override
            protected void sampleGauges(Integer chipNum, SIDEmu sid, boolean isLowerResolution) {
                if (chipNum < 3) {
                    Oscilloscope.this.wav0[chipNum].sample(sid).advance();
                    Oscilloscope.this.wav1[chipNum].sample(sid).advance();
                    Oscilloscope.this.wav2[chipNum].sample(sid).advance();
                    Oscilloscope.this.env0[chipNum].sample(sid);
                    Oscilloscope.this.env1[chipNum].sample(sid);
                    Oscilloscope.this.env2[chipNum].sample(sid);
                    Oscilloscope.this.frq0[chipNum].sample(sid);
                    Oscilloscope.this.frq1[chipNum].sample(sid);
                    Oscilloscope.this.frq2[chipNum].sample(sid);
                    Oscilloscope.this.vol[chipNum].sample(sid).advance();
                    Oscilloscope.this.res[chipNum].sample(sid);
                    Oscilloscope.this.fil[chipNum].sample(sid);
                    if (isLowerResolution) {
                        Oscilloscope.this.env0[chipNum].advance();
                        Oscilloscope.this.env1[chipNum].advance();
                        Oscilloscope.this.env2[chipNum].advance();
                        Oscilloscope.this.frq0[chipNum].advance();
                        Oscilloscope.this.frq1[chipNum].advance();
                        Oscilloscope.this.frq2[chipNum].advance();
                        Oscilloscope.this.res[chipNum].advance();
                        Oscilloscope.this.fil[chipNum].advance();
                    }
                }
            }

            @Override
            protected void updateGauges(Integer chipNum, SIDEmu sid) {
                if (chipNum < 3) {
                    Oscilloscope.this.wav0[chipNum].draw(sid);
                    Oscilloscope.this.wav1[chipNum].draw(sid);
                    Oscilloscope.this.wav2[chipNum].draw(sid);
                    Oscilloscope.this.env0[chipNum].draw(sid);
                    Oscilloscope.this.env1[chipNum].draw(sid);
                    Oscilloscope.this.env2[chipNum].draw(sid);
                    Oscilloscope.this.frq0[chipNum].draw(sid);
                    Oscilloscope.this.frq1[chipNum].draw(sid);
                    Oscilloscope.this.frq2[chipNum].draw(sid);
                    Oscilloscope.this.vol[chipNum].draw(sid);
                    Oscilloscope.this.res[chipNum].draw(sid);
                    Oscilloscope.this.fil[chipNum].draw(sid);
                    int fastForwardBitMask = mixer.getFastForwardBitMask();
                    if ((Oscilloscope.this.fastForwardVICFrames & fastForwardBitMask) == fastForwardBitMask) {
                        importedApi.processOsc(chipNum, ((Oscilloscope)Oscilloscope.this).wav0[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).wav0[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).wav1[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).wav1[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).wav2[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).wav2[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).env0[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).env0[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).env1[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).env1[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).env2[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).env2[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).frq0[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).frq0[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).frq1[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).frq1[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).frq2[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).frq2[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).vol[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).vol[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).res[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).res[chipNum.intValue()].text, ((Oscilloscope)Oscilloscope.this).fil[chipNum.intValue()].path, ((Oscilloscope)Oscilloscope.this).fil[chipNum.intValue()].text);
                    }
                    if (chipNum == 0) {
                        Oscilloscope.this.fastForwardVICFrames++;
                    }
                }
            }
        };
    }

    public void start(double fps) {
        this.oscilloscopeUtil.start(fps);
    }

    public void stop() {
        this.oscilloscopeUtil.stop();
    }
}

