/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import server.restful.common.ServletUtil;

public abstract class HttpAsyncContextRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HttpAsyncContextRunnable.class.getName());
    private AsyncContext asyncContext;
    private ServletContext servletContext;
    private AtomicBoolean completed = new AtomicBoolean();
    protected Thread parentThread;

    public HttpAsyncContextRunnable(final AsyncContext asyncContext, final ServletContext servletContext) {
        this.asyncContext = asyncContext;
        this.servletContext = servletContext;
        this.parentThread = Thread.currentThread();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
                HttpAsyncContextRunnable.this.getAndSetComplete();
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                ServletUtil.warn(servletContext, "Asynchronous servlet timeout", HttpAsyncContextRunnable.this.parentThread);
                HttpAsyncContextRunnable.this.getResponse().setStatus(503);
                HttpAsyncContextRunnable.this.getResponse().getOutputStream().flush();
            }

            public void onError(AsyncEvent event) throws IOException {
                if (LOG.isLoggable(Level.FINEST)) {
                    ServletUtil.error(servletContext, event.getThrowable(), new Thread[0]);
                } else {
                    ServletUtil.warn(servletContext, event.getThrowable().getMessage(), new Thread[0]);
                }
                if (!HttpAsyncContextRunnable.this.getAndSetComplete()) {
                    asyncContext.complete();
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
    }

    protected boolean isComplete() {
        return this.completed.get();
    }

    private boolean getAndSetComplete() {
        return this.completed.getAndSet(true);
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)this.asyncContext.getRequest();
    }

    private HttpServletResponse getResponse() {
        return (HttpServletResponse)this.asyncContext.getResponse();
    }

    @Override
    public final void run() {
        try {
            if (!this.isComplete()) {
                this.run(this.getRequest(), this.getResponse());
            }
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.FINEST)) {
                ServletUtil.error(this.servletContext, t, this.parentThread);
            } else {
                ServletUtil.warn(this.servletContext, t.getMessage(), this.parentThread);
            }
        }
        finally {
            if (!this.getAndSetComplete()) {
                this.asyncContext.complete();
            }
        }
    }

    protected abstract void run(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

