/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.log;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MonitoringThread
extends Thread {
    private long refreshInterval;
    private volatile boolean stopped;
    private Map<Long, ThreadTime> threadTimeMap = new HashMap<Long, ThreadTime>();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private OperatingSystemMXBean opBean = ManagementFactory.getOperatingSystemMXBean();

    public MonitoringThread(long refreshInterval) {
        this.refreshInterval = refreshInterval;
        this.setName("MonitoringThread");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            ThreadTime threadTime;
            ThreadTime threadTime2;
            HashSet<ThreadTime> values;
            HashSet<Long> mappedIds;
            Map<Long, ThreadTime> map = this.threadTimeMap;
            synchronized (map) {
                mappedIds = new HashSet<Long>(this.threadTimeMap.keySet());
            }
            long[] allThreadIds = this.threadBean.getAllThreadIds();
            this.removeDeadThreads(mappedIds, allThreadIds);
            this.mapNewThreads(allThreadIds);
            Iterator iterator = this.threadTimeMap;
            synchronized (iterator) {
                values = new HashSet<ThreadTime>(this.threadTimeMap.values());
            }
            iterator = values.iterator();
            while (iterator.hasNext()) {
                threadTime = threadTime2 = (ThreadTime)iterator.next();
                synchronized (threadTime) {
                    threadTime2.setCurrent(this.threadBean.getThreadCpuTime(threadTime2.getId()));
                }
            }
            try {
                Thread.sleep(this.refreshInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            iterator = values.iterator();
            while (iterator.hasNext()) {
                threadTime = threadTime2 = (ThreadTime)iterator.next();
                synchronized (threadTime) {
                    threadTime2.setLast(threadTime2.getCurrent());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapNewThreads(long[] allThreadIds) {
        for (long id : allThreadIds) {
            Map<Long, ThreadTime> map = this.threadTimeMap;
            synchronized (map) {
                if (!this.threadTimeMap.containsKey(id)) {
                    this.threadTimeMap.put(id, new ThreadTime(id));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeadThreads(Set<Long> mappedIds, long[] allThreadIds) {
        block3: for (long id1 : mappedIds) {
            for (long id2 : allThreadIds) {
                if (id1 == id2) continue block3;
            }
            Map<Long, ThreadTime> map = this.threadTimeMap;
            synchronized (map) {
                this.threadTimeMap.remove(id1);
            }
        }
    }

    public void stopMonitor() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalUsage() {
        HashSet<ThreadTime> values;
        Map<Long, ThreadTime> map = this.threadTimeMap;
        synchronized (map) {
            values = new HashSet<ThreadTime>(this.threadTimeMap.values());
        }
        double usage = 0.0;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            ThreadTime threadTime;
            ThreadTime threadTime2 = threadTime = (ThreadTime)iterator.next();
            synchronized (threadTime2) {
                usage += (double)((threadTime.getCurrent() - threadTime.getLast()) / (this.refreshInterval * 10000L));
            }
        }
        return usage;
    }

    public double getAvarageUsagePerCPU() {
        return this.getTotalUsage() / (double)this.opBean.getAvailableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getUsageByThread(Thread t) {
        ThreadTime info;
        Map<Long, ThreadTime> map = this.threadTimeMap;
        synchronized (map) {
            info = this.threadTimeMap.get(t.getId());
        }
        double usage = 0.0;
        if (info != null) {
            ThreadTime threadTime = info;
            synchronized (threadTime) {
                usage = (info.getCurrent() - info.getLast()) / (this.refreshInterval * 10000L);
            }
        }
        return usage;
    }

    static class ThreadTime {
        private long id;
        private long last;
        private long current;

        public ThreadTime(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public long getLast() {
            return this.last;
        }

        public void setLast(long last) {
            this.last = last;
        }

        public long getCurrent() {
            return this.current;
        }

        public void setCurrent(long current) {
            this.current = current;
        }
    }
}

