/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter.usage;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import server.restful.common.IServletSystemProperties;

public class ServletsUsageFormatter
extends DefaultUsageFormatter {
    private JCommander commander;

    public ServletsUsageFormatter(JCommander commander) {
        super(commander);
        this.commander = commander;
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        if (!hasCommands) {
            try {
                out.append("\n\n==== ").append(this.getBundle(this.commander).getString("USAGE_DESCRIPTION")).append("\n");
                this.appendExampleUsage(out, indentCount, indent, false, null);
                out.append("\n\n").append(this.getBundle(this.commander).getString("USAGE_LONG_DESCRIPTION")).append("\n\n");
                this.appendExampleUsage(out, indentCount, indent, true, this.getBundle(this.commander).getString("EXAMPLE_REQUEST_PATH"));
                try {
                    String optionalUsageDescription = this.getBundle(this.commander).getString("USAGE_DESCRIPTION2");
                    out.append("\n\n==== ").append(optionalUsageDescription).append("\n");
                    this.appendExampleUsage(out, indentCount, indent, false, null);
                    out.append("\n\n").append(this.getBundle(this.commander).getString("USAGE_LONG_DESCRIPTION2")).append("\n\n");
                    this.appendExampleUsage(out, indentCount, indent, true, this.getBundle(this.commander).getString("EXAMPLE_REQUEST_PATH2"));
                }
                catch (MissingResourceException optionalUsageDescription) {}
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
    }

    public void usage(StringBuilder out, String indent) {
        if (this.commander.getDescriptions() == null) {
            this.commander.createDescriptions();
        }
        boolean hasCommands = !this.commander.getCommands().isEmpty();
        boolean hasOptions = !this.commander.getDescriptions().isEmpty();
        int descriptionIndent = 6;
        int indentCount = indent.length() + 6;
        this.appendMainLine(out, hasOptions, hasCommands, indentCount, indent);
        List sortedParameters = Lists.newArrayList();
        for (ParameterDescription pd : this.commander.getFields().values()) {
            if (pd.getParameter().hidden()) continue;
            sortedParameters.add(pd);
        }
        sortedParameters.sort(this.commander.getParameterDescriptionComparator());
        this.appendAllParametersDetails(out, indentCount, indent, sortedParameters);
        if (hasCommands) {
            this.appendCommands(out, indentCount, 6, indent);
        }
    }

    public void appendCommands(StringBuilder out, int indentCount, int descriptionIndent, String indent) {
        Parameters p;
        Object arg;
        boolean hasOnlyHiddenCommands = true;
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            hasOnlyHiddenCommands = false;
        }
        if (hasOnlyHiddenCommands) {
            return;
        }
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            JCommander.ProgramName progName = (JCommander.ProgramName)commands.getKey();
            JCommander jc = this.commander.findCommandByAlias(progName.getName());
            jc.setUsageFormatter((IUsageFormatter)new ServletsUsageFormatter(jc));
            jc.getUsageFormatter().usage(out, indent + ServletsUsageFormatter.s((int)6));
        }
    }

    private void appendExampleUsage(StringBuilder out, int indentCount, String indent, boolean exampleOrUsage, String exampleRequestPath) throws MalformedURLException, URISyntaxException {
        out.append(exampleOrUsage ? "Example:\n" : "");
        out.append("\n");
        out.append(this.createExampleUsage(indent, exampleOrUsage, exampleRequestPath));
        out.append("\n");
        out.append("\n");
    }

    private String createExampleUsage(String indent, boolean exampleOrUsage, String exampleRequestPath) throws MalformedURLException, URISyntaxException {
        StringBuilder result = new StringBuilder();
        ResourceBundle bundle = this.getBundle(this.commander);
        StringBuilder urlAsString = new StringBuilder();
        urlAsString.append(IServletSystemProperties.JSIDPlay2Server.BASE_URL);
        urlAsString.append(bundle.getString("EXAMPLE_REQUEST_SERVLET_PATH"));
        if (exampleOrUsage && this.commander.getMainParameter() != null) {
            urlAsString.append(exampleRequestPath);
        }
        StringBuilder queryParameters = new StringBuilder();
        Iterator it = this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden() && pd.getDefault() != null).sorted(this.commander.getParameterDescriptionComparator()).collect(Collectors.toList()).iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                ParameterDescription def = (ParameterDescription)it.next();
                queryParameters.append(this.getExampleServletParameterName(def.getNames()));
                queryParameters.append("=");
                queryParameters.append(def.getParameter().password() ? "********" : (def.getNames().equals("--hls") ? "true" : String.valueOf(def.getDefault())));
                if (!it.hasNext()) continue;
                queryParameters.append("&");
            }
        }
        URL url = new URI(urlAsString.toString()).toURL();
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), exampleOrUsage && queryParameters.length() > 0 ? queryParameters.toString() : "help=true", url.getRef());
        result.append("link:" + uri.toASCIIString().replace("*", "%2A") + "[" + (exampleOrUsage ? uri.toASCIIString().replace("*", "%2A") : "Usage") + "]");
        return result.toString();
    }

    private String getExampleServletParameterName(String names) {
        return Arrays.asList(names.split(", ")).stream().map(this::getParameterName).max(Comparator.comparingInt(String::length)).orElse("");
    }

    private ResourceBundle getBundle(JCommander commander) {
        Object firstParameterObject = commander.getObjects().get(0);
        Parameters parameters = firstParameterObject.getClass().getAnnotation(Parameters.class);
        return ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
    }

    private String getParameterName(String name) {
        if (name.startsWith("--")) {
            return name.substring("--".length());
        }
        if (name.startsWith("-")) {
            return name.substring("-".length());
        }
        return name;
    }
}

