/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.DirectoryRequestPathServletParameters;

@WebServlet(name="DirectoryServlet", displayName="DirectoryServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/directory/*"}, description="Get directory contents containing music collections")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class DirectoryServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.DirectoryServlet.MAX_DIRECTORY_IN_PARALLEL, new DefaultThreadFactory("/directory"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.DirectoryServlet.DIRECTORY_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        DirectoryServletParameters servletParameters = new DirectoryServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        List<String> files = servletParameters.fetchDirectory(DirectoryServlet.this.configuration, DirectoryServlet.this.directoryProperties, parser, DirectoryServlet.this.hasAdminAccess(request));
                        if (files == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        if (!this.isComplete()) {
                            DirectoryServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, files);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(DirectoryServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        DirectoryServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.DirectoryServletParameters")
    public static class DirectoryServletParameters
    extends DirectoryRequestPathServletParameters {
    }
}

