/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.converter.WebResourceConverter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.entities.config.FavoritesSection;

@WebServlet(name="FavoritesNamesServlet", displayName="FavoritesNamesServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/favorite_names"}, description="Get names of all favorites tab")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class FavoritesNamesServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            FavoriteNamesServletParameters servletParameters = new FavoriteNamesServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            List<String> favoritesNames = this.getFavoritesNames();
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, favoritesNames);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private List<String> getFavoritesNames() {
        List<String> filters = this.configuration.getFavorites().stream().map(FavoritesSection::getName).collect(Collectors.toList());
        int i = 0;
        while (true) {
            String resource = String.format("/favorites/jsidplay2-%d.json", i);
            try (InputStream source = new WebResourceConverter("<ServletPath>").convert(resource);){
                filters.add(String.format("Playlist-%d", ++i));
            }
            catch (ParameterException | IOException e) {
                return filters;
            }
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.FavoritesNamesServletParameters")
    public static class FavoriteNamesServletParameters
    extends UsageParameter {
    }
}

