/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;

@WebServlet(name="RandomHVSCServlet", displayName="RandomHVSCServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/random-hvsc"}, description="Get random HVSC SID tune")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class RandomHVSCServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RandomHVSCServletParameters servletParameters = new RandomHVSCServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            String randomHVSC = this.getRandomHVSC();
            ServletUtil.info(this.getServletContext(), String.format("randomHVSC: %s", randomHVSC), new Thread[0]);
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, randomHVSC);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private String getRandomHVSC() {
        String rndPath;
        if (this.sidDatabase != null && (rndPath = this.sidDatabase.getRandomPath()) != null) {
            return "/C64Music" + rndPath;
        }
        return null;
    }

    @Parameters(resourceBundle="server.restful.servlets.RandomHVSCServletParameters")
    public static class RandomHVSCServletParameters
    extends UsageParameter {
    }
}

