/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;

public class JavaSound
implements AudioDriver {
    private AudioConfig cfg;
    private AudioFormat audioFormat;
    private SourceDataLine dataLine;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.open(new AudioConfig(audioSection), JavaSound.getDeviceInfo(audioSection));
    }

    public void open(AudioConfig cfg, Mixer.Info info) throws LineUnavailableException {
        this.cfg = cfg;
        boolean signed = true;
        boolean bigEndian = false;
        this.audioFormat = new AudioFormat(cfg.getFrameRate(), 16, cfg.getChannels(), signed, bigEndian);
        this.setAudioDevice(info);
    }

    public void setAudioDevice(Mixer.Info info) throws LineUnavailableException {
        try {
            this.close();
            this.dataLine = AudioSystem.getSourceDataLine(this.audioFormat, info);
            this.dataLine.open(this.dataLine.getFormat(), this.cfg.getBufferFrames() * 2 * this.cfg.getChannels());
            this.dataLine.start();
            this.cfg.setBufferFrames(this.dataLine.getBufferSize() / 2 / this.cfg.getChannels());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
        this.sampleBuffer = ByteBuffer.allocate(this.cfg.getChunkFrames() * 2 * this.cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        if (this.dataLine == null) {
            return;
        }
        if (!this.dataLine.isActive()) {
            this.dataLine.start();
        }
        this.dataLine.write(this.sampleBuffer.array(), 0, this.sampleBuffer.position());
    }

    public int getRemainingPlayTime() {
        if (this.dataLine == null) {
            return 0;
        }
        int bytesPerFrame = this.dataLine.getFormat().getChannels() * 2;
        int framesPlayed = this.dataLine.available() / bytesPerFrame;
        int framesTotal = this.dataLine.getBufferSize() / bytesPerFrame;
        int framesNotYetPlayed = framesTotal - framesPlayed;
        return framesNotYetPlayed * 1000 / framesTotal;
    }

    @Override
    public void pause() {
        if (this.dataLine != null && this.dataLine.isActive()) {
            this.dataLine.stop();
        }
    }

    public void flush() {
        if (this.dataLine != null && this.dataLine.isActive()) {
            this.dataLine.flush();
        }
    }

    @Override
    public void close() {
        if (this.dataLine == null) {
            return;
        }
        if (this.dataLine.isActive()) {
            if (this.dataLine.isRunning()) {
                this.dataLine.drain();
            }
            this.dataLine.stop();
            this.dataLine.flush();
        }
        if (this.dataLine.isOpen()) {
            this.dataLine.close();
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    public static final Mixer.Info getDeviceInfo(IAudioSection audioSection) {
        List<Mixer.Info> devices = JavaSound.getDeviceInfos();
        return IntStream.range(0, devices.size()).filter(i -> i == audioSection.getDevice()).mapToObj(devices::get).findFirst().orElse(null);
    }

    public static final List<Mixer.Info> getDeviceInfos() {
        return Arrays.asList(AudioSystem.getMixerInfo()).stream().map(AudioSystem::getMixer).filter(mixer -> mixer.isLineSupported(new Line.Info(SourceDataLine.class))).map(Mixer::getMixerInfo).collect(Collectors.toList());
    }
}

