/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDListener;
import libsidplay.components.mos6510.IMOS6510Extension;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioDriver;
import sidplay.audio.VideoDriver;

public class ProxyDriver
implements AudioDriver,
VideoDriver,
SIDListener,
IMOS6510Extension {
    private final AudioDriver driverOne;
    private final AudioDriver driverTwo;

    public ProxyDriver(AudioDriver driver1, AudioDriver driver2) {
        this.driverOne = driver1;
        this.driverTwo = driver2;
    }

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.driverOne.open(audioSection, recordingFilename, cpuClock, context);
        this.driverTwo.open(audioSection, recordingFilename, cpuClock, context);
    }

    @Override
    public void pause() {
        this.driverOne.pause();
        this.driverTwo.pause();
    }

    @Override
    public void write() throws InterruptedException {
        this.driverOne.write();
        ByteBuffer driverTwoBuffer = this.driverTwo.buffer();
        if (driverTwoBuffer != null) {
            ByteBuffer readOnlyCopy = this.driverOne.buffer().asReadOnlyBuffer();
            ((Buffer)readOnlyCopy).flip();
            ((Buffer)driverTwoBuffer).clear();
            driverTwoBuffer.put(readOnlyCopy);
            this.driverTwo.write();
        }
    }

    @Override
    public void accept(VIC vic) {
        if (this.driverOne instanceof VideoDriver) {
            ((VideoDriver)((Object)this.driverOne)).accept(vic);
        }
        if (this.driverTwo instanceof VideoDriver) {
            ((VideoDriver)((Object)this.driverTwo)).accept(vic);
        }
    }

    @Override
    public void write(int addr, byte data) {
        if (this.driverOne instanceof SIDListener) {
            ((SIDListener)((Object)this.driverOne)).write(addr, data);
        }
        if (this.driverTwo instanceof SIDListener) {
            ((SIDListener)((Object)this.driverTwo)).write(addr, data);
        }
    }

    @Override
    public void jmpJsr() {
        if (this.driverOne instanceof IMOS6510Extension) {
            ((IMOS6510Extension)((Object)this.driverOne)).jmpJsr();
        }
        if (this.driverTwo instanceof IMOS6510Extension) {
            ((IMOS6510Extension)((Object)this.driverTwo)).jmpJsr();
        }
    }

    @Override
    public void close() {
        this.driverOne.close();
        this.driverTwo.close();
    }

    @Override
    public ByteBuffer buffer() {
        return this.driverOne.buffer();
    }

    @Override
    public boolean isRecording() {
        return this.driverOne.isRecording() || this.driverTwo.isRecording();
    }

    @Override
    public String getExtension() {
        return this.driverOne.getExtension() != null ? this.driverOne.getExtension() : this.driverTwo.getExtension();
    }

    @Override
    public <T extends AudioDriver> Optional<T> lookup(Class<T> clz) {
        if (clz.isInstance(this.driverOne)) {
            return Optional.of((AudioDriver)clz.cast(this.driverOne));
        }
        if (clz.isInstance(this.driverTwo)) {
            return Optional.of((AudioDriver)clz.cast(this.driverTwo));
        }
        return Optional.empty();
    }

    public AudioDriver getDriverOne() {
        return this.driverOne;
    }

    public AudioDriver getDriverTwo() {
        return this.driverTwo;
    }
}

