/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.processors.reverb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import sidplay.audio.processors.AudioProcessor;
import sidplay.audio.processors.reverb.SchroederReverb;

public class ReverbProcessor
implements AudioProcessor {
    private SchroederReverb reverb;
    private IAudioSection audioSection;

    public ReverbProcessor(IConfig config) {
        this.audioSection = config.getAudioSection();
    }

    @Override
    public void process(ByteBuffer sampleBuffer) {
        if (!this.audioSection.getReverbBypass()) {
            if (this.reverb == null) {
                this.reverb = new SchroederReverb(this.audioSection.getSamplingRate().getFrequency(), 2, sampleBuffer.capacity());
            }
            if (this.reverb.comb1.getDelayInMs() != (double)this.audioSection.getReverbComb1Delay()) {
                this.reverb.comb1.setDelayInMs(this.audioSection.getReverbComb1Delay());
            }
            if (this.reverb.comb2.getDelayInMs() != (double)this.audioSection.getReverbComb2Delay()) {
                this.reverb.comb2.setDelayInMs(this.audioSection.getReverbComb2Delay());
            }
            if (this.reverb.comb3.getDelayInMs() != (double)this.audioSection.getReverbComb3Delay()) {
                this.reverb.comb3.setDelayInMs(this.audioSection.getReverbComb3Delay());
            }
            if (this.reverb.comb4.getDelayInMs() != (double)this.audioSection.getReverbComb4Delay()) {
                this.reverb.comb4.setDelayInMs(this.audioSection.getReverbComb4Delay());
            }
            if (this.reverb.allpass1.getDelayInMs() != (double)this.audioSection.getReverbAllPass1Delay()) {
                this.reverb.allpass1.setDelayInMs(this.audioSection.getReverbAllPass1Delay());
            }
            if (this.reverb.allpass2.getDelayInMs() != (double)this.audioSection.getReverbAllPass2Delay()) {
                this.reverb.allpass2.setDelayInMs(this.audioSection.getReverbAllPass2Delay());
            }
            if (this.reverb.comb1.getSustainTimeInMs() != (double)this.audioSection.getReverbSustainDelay()) {
                this.reverb.comb1.setSustainTimeInMs(this.audioSection.getReverbSustainDelay());
                this.reverb.comb2.setSustainTimeInMs(this.audioSection.getReverbSustainDelay());
                this.reverb.comb3.setSustainTimeInMs(this.audioSection.getReverbSustainDelay());
                this.reverb.comb4.setSustainTimeInMs(this.audioSection.getReverbSustainDelay());
            }
            if (this.reverb.mix != (double)this.audioSection.getReverbDryWetMix()) {
                this.reverb.mix = this.audioSection.getReverbDryWetMix();
            }
            short[] dest = new short[sampleBuffer.position() >> 1];
            ((Buffer)sampleBuffer).flip();
            sampleBuffer.asShortBuffer().get(dest);
            int newLen = this.reverb.doReverb(dest, dest.length);
            sampleBuffer.asShortBuffer().put(dest, 0, newLen);
            ((Buffer)sampleBuffer).position(newLen << 1);
        }
    }
}

