/*
 * Decompiled with CFR 0.152.
 */
package ui.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;

public class ConsoleOutput
extends C64VBox
implements UIPart {
    private StringBuilder output = new StringBuilder();
    @FXML
    protected TextArea console;
    @FXML
    private TitledPane titledPane;

    public ConsoleOutput() {
    }

    public ConsoleOutput(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected void initialize() {
    }

    @FXML
    private void clearConsole() {
        this.console.clear();
        this.output.setLength(0);
    }

    public PrintStream getPrintStream(final OutputStream original) throws UnsupportedEncodingException {
        return new PrintStream(new OutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                original.write(b, off, len);
                this.print(new String(b, off, len, StandardCharsets.UTF_8));
            }

            @Override
            public synchronized void write(int ch) throws IOException {
                original.write(ch);
                this.print(String.valueOf((char)ch));
            }

            private void print(String str) {
                ConsoleOutput.this.output.append(str);
                if (str.indexOf(10) != -1) {
                    Platform.runLater(() -> {
                        ConsoleOutput.this.console.setText(ConsoleOutput.this.output.toString());
                        ConsoleOutput.this.console.setScrollTop(Double.MAX_VALUE);
                    });
                }
            }
        }, false, StandardCharsets.UTF_8.name());
    }

    public TitledPane getTitledPane() {
        return this.titledPane;
    }

    public TextArea getConsole() {
        return this.console;
    }
}

