/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import java.net.URL;
import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import libsidplay.common.SIDEmu;
import libsidutils.oscilloscope.GaugeUtil;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.ImageQueue;
import ui.common.UIPart;
import ui.oscilloscope.GaugeImage;

public class Gauge
extends C64VBox
implements UIPart {
    private static final int ALPHA = -16777216;
    private static final int[] gaugeColors = new int[256];
    private String text;
    private int voice;
    private int[] pixels;
    private GaugeUtil gaugeUtil;
    private int width;
    private int height;
    private ImageQueue<GaugeImage> imageQueue = new ImageQueue();

    public Gauge() {
    }

    public Gauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.width = (int)this.getArea().getFitWidth();
        this.height = (int)this.getArea().getFitHeight();
        this.gaugeUtil = new GaugeUtil(this.width, this.height){

            @Override
            protected void drawLine(int x, int y1, int x2, int y2, int color) {
                Gauge.this.drawLine(Gauge.this.pixels, x, y1, x2, y2, color);
            }
        };
    }

    @Override
    public String getBundleName() {
        return Gauge.class.getName();
    }

    @Override
    public URL getFxml() {
        return this.getClass().getResource(Gauge.class.getSimpleName() + ".fxml");
    }

    public int getVoice() {
        return this.voice;
    }

    public void setVoice(int voice) {
        this.voice = voice;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected void accumulate(float value) {
        this.gaugeUtil.accumulate(value);
    }

    protected void advance() {
        this.gaugeUtil.advance();
    }

    public void reset() {
        this.gaugeUtil.reset();
        this.imageQueue.clear();
        this.addImage(null);
        this.updateGauge();
    }

    public void updateGauge() {
        GaugeImage gaugeImage = this.imageQueue.pull();
        if (gaugeImage != null) {
            this.getTitledPane().setText(gaugeImage.getText());
            WritableImage image = new WritableImage(this.width, this.height);
            image.getPixelWriter().setPixels(0, 0, this.width, this.height, (PixelFormat)PixelFormat.getIntArgbInstance(), gaugeImage.getPixels(), 0, this.width);
            this.getArea().setImage((Image)image);
        }
    }

    public void addImage(SIDEmu sidemu) {
        this.pixels = new int[this.width * this.height];
        this.gaugeUtil.draw(sidemu);
        this.imageQueue.push(new GaugeImage(this.pixels, this.text));
    }

    private void drawLine(int[] pixels, int x1, int y1, int x2, int y2, int c) {
        x1 = Math.min(Math.max(0, x1), this.width - 1);
        x2 = Math.min(Math.max(0, x2), this.width - 1);
        y1 = Math.min(Math.max(0, y1), this.height - 1);
        y2 = Math.min(Math.max(0, y2), this.height - 1);
        int d = 0;
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dx2 = 2 * dx;
        int dy2 = 2 * dy;
        int ix = x1 < x2 ? 1 : -1;
        int iy = y1 < y2 ? 1 : -1;
        int x = x1;
        int y = y1;
        if (dx >= dy) {
            while (true) {
                pixels[x + this.width * y] = c;
                if (x != x2) {
                    x += ix;
                    if ((d += dy2) <= dx) continue;
                    y += iy;
                    d -= dx2;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                pixels[x + this.width * y] = c;
                if (y == y2) break;
                y += iy;
                if ((d += dx2) <= dy) continue;
                x += ix;
                d -= dy2;
            }
        }
    }

    protected TitledPane getTitledPane() {
        return null;
    }

    protected ImageView getArea() {
        return null;
    }

    @Override
    public void doClose() {
        this.imageQueue.dispose();
    }

    static {
        for (int i = 0; i < gaugeColors.length; ++i) {
            int color = Math.round((float)Math.sqrt((float)i / 255.0f) * 255.0f);
            Gauge.gaugeColors[i] = 0xFF000000 | (color & 0xFF) << 8 | color >> 8;
        }
    }
}

