/*
 * Decompiled with CFR 0.152.
 */
package ui.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextArea;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.util.DesktopUtil;
import ui.common.util.VersionUtil;
import ui.entities.config.SidPlay2Section;

public class Update
extends C64Window {
    @FXML
    private TextArea update;
    @FXML
    private Hyperlink latestVersionLink;

    public Update() {
    }

    public Update(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        final SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        this.update.setText(this.util.getBundle().getString("PLEASE_WAIT"));
        Task<Void> task = new Task<Void>(){

            public Void call() throws Exception {
                String remoteVersion = VersionUtil.fetchRemoteVersion(sidplay2Section);
                boolean updateAvailable = remoteVersion != null && Update.this.isUpdateAvailable(Update.this.getVersionNumbers(VersionUtil.VERSION), Update.this.getVersionNumbers(remoteVersion));
                Update.this.latestVersionLink.setVisible(updateAvailable);
                Update.this.update.setText(Update.this.util.getBundle().getString(updateAvailable ? "UPDATE_AVAILABLE" : "NO_UPDATE"));
                return null;
            }
        };
        new Thread((Runnable)task).start();
    }

    @FXML
    private void gotoLatestVersion() {
        DesktopUtil.browse("http://sourceforge.net/projects/jsidplay2/files/latest/download");
    }

    @FXML
    private void okPressed(ActionEvent event) {
        this.close();
    }

    private boolean isUpdateAvailable(int[] currentVersion, int[] latestVersion) {
        if (currentVersion == null || latestVersion == null) {
            return false;
        }
        for (int i = 0; i < currentVersion.length; ++i) {
            if (currentVersion[i] == latestVersion[i]) continue;
            return currentVersion[i] < latestVersion[i];
        }
        return false;
    }

    private int[] getVersionNumbers(String version) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)").matcher(version);
        if (!m.matches()) {
            System.err.println("Malformed version number: " + version);
            return null;
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }
}

