/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.java.truecommons.key.spec.AbstractKey;
import net.java.truecommons.key.spec.SecretKey;
import net.java.truecommons.shed.Buffers;
import net.java.truecommons.shed.Option;

public abstract class AbstractSecretKey<K extends AbstractSecretKey<K>>
extends AbstractKey<K>
implements SecretKey<K> {
    private transient Option<ByteBuffer> secret = Option.none();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.secret = Option.none();
    }

    @Override
    public K clone() {
        AbstractSecretKey clone = (AbstractSecretKey)super.clone();
        clone.secret = Option.apply((Object)Buffers.copy((ByteBuffer)((ByteBuffer)this.secret.orNull())));
        return (K)clone;
    }

    @Override
    public void reset() {
        this.doReset();
    }

    private void doReset() {
        for (ByteBuffer bb : this.secret) {
            Buffers.fill((ByteBuffer)bb, (byte)0);
        }
        this.secret = Option.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.doReset();
        }
        finally {
            super.finalize();
        }
    }

    @Transient
    public final boolean isSecretSet() {
        return !this.secret.isEmpty();
    }

    @Override
    @Transient
    @Nullable
    public final ByteBuffer getSecret() {
        return Buffers.copy((ByteBuffer)((ByteBuffer)this.secret.orNull()));
    }

    @Override
    public final void setSecret(@Nullable ByteBuffer secret) {
        this.doReset();
        this.secret = Option.apply((Object)Buffers.copy((ByteBuffer)secret));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractSecretKey that = (AbstractSecretKey)obj;
        return Objects.equals(this.secret, that.secret);
    }

    @Override
    public int hashCode() {
        int c = 17;
        c = 31 * c + Objects.hashCode(this.secret);
        return c;
    }

    public String toString() {
        return String.format("%s[secretSet=%b]", super.toString(), this.isSecretSet());
    }
}

