/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.SharedKeyProvider;
import net.java.truecommons.shed.Option;
import net.java.truecommons.shed.UniqueObject;

@ThreadSafe
final class SharedKeyManager<K extends PromptingKey<K>>
extends UniqueObject {
    private final Map<URI, SharedKeyProvider<K>> providers = new HashMap<URI, SharedKeyProvider<K>>();

    SharedKeyManager() {
    }

    private Option<SharedKeyProvider<K>> get(URI uri) {
        return Option.apply(this.providers.get(uri));
    }

    private Option<SharedKeyProvider<K>> put(URI uri, SharedKeyProvider<K> p) {
        return Option.apply(this.providers.put(uri, p));
    }

    private Option<SharedKeyProvider<K>> remove(URI uri) {
        return Option.apply(this.providers.remove(uri));
    }

    synchronized SharedKeyProvider<K> provider(URI uri) {
        Iterator i$ = this.get(uri).iterator();
        if (i$.hasNext()) {
            SharedKeyProvider p = (SharedKeyProvider)((Object)i$.next());
            return p;
        }
        SharedKeyProvider p = new SharedKeyProvider();
        this.put(uri, p);
        p.link();
        return p;
    }

    synchronized void release(URI uri) {
        for (SharedKeyProvider p : this.get(uri)) {
            p.release();
        }
    }

    synchronized void link(URI originUri, URI targetUri) {
        for (SharedKeyProvider originProvider : this.get(originUri)) {
            for (SharedKeyProvider targetProvider : this.put(targetUri, originProvider)) {
                if (targetProvider == originProvider) {
                    return;
                }
                targetProvider.unlink();
            }
            originProvider.link();
        }
    }

    synchronized void unlink(URI uri) {
        for (SharedKeyProvider p : this.remove(uri)) {
            p.unlink();
        }
    }
}

