/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resample;

import builder.resid.resample.Resampler;
import builder.resid.resample.TwoPassSincResampler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class SincResampler
implements Resampler {
    private static final int RINGSIZE = 2048;
    private static final int BITS = 16;
    private final int[] sample = new int[4096];
    private int[][] fir;
    private int sampleIndex;
    private int firRES;
    private int firN;
    private final int cyclesPerSample;
    private int sampleOffset;
    private int output;
    private static Map<String, int[][]> FIR_CACHE = new HashMap<String, int[][]>();
    private static final double I0E = 1.0E-6;

    private static double I0(double x) {
        double temp;
        double sum = 1.0;
        double u = 1.0;
        double n = 1.0;
        double halfx = x / 2.0;
        do {
            temp = halfx / n;
            n += 1.0;
        } while (u >= 1.0E-6 * (sum += (u *= temp * temp)));
        return sum;
    }

    private static int convolve(int[] a, int aPos, int[] b) {
        int out = 0;
        int i = 0;
        while (i < b.length) {
            out += a[aPos] * b[i];
            ++i;
            ++aPos;
        }
        return out + 16384 >> 15;
    }

    public SincResampler(double clockFrequency, double samplingFrequency, double highestAccurateFrequency) {
        this.cyclesPerSample = (int)(clockFrequency / samplingFrequency * 1024.0);
        double A = -20.0 * Math.log10(1.52587890625E-5);
        double dw = (1.0 - 2.0 * highestAccurateFrequency / samplingFrequency) * Math.PI * 2.0;
        double beta = 0.1102 * (A - 8.7);
        double I0beta = SincResampler.I0(beta);
        double cyclesPerSampleD = clockFrequency / samplingFrequency;
        int N = (int)((A - 7.95) / (2.285 * dw) + 0.5);
        N += N & 1;
        this.firN = (int)((double)N * cyclesPerSampleD) + 1;
        this.firN |= 1;
        if (this.firN > 2047) {
            throw new RuntimeException(String.format("Resampling quality exceeds the available buffer: %d required, but only has %d", this.firN, 2048));
        }
        this.firRES = (int)Math.ceil(Math.sqrt(80871.424) / cyclesPerSampleD);
        double wc = Math.PI;
        String firKey = this.firN + "," + this.firRES + "," + cyclesPerSampleD;
        this.fir = FIR_CACHE.get(firKey);
        if (this.fir == null) {
            this.fir = new int[this.firRES][];
            for (int i = 0; i < this.firRES; ++i) {
                this.fir[i] = new int[this.firN];
            }
            FIR_CACHE.put(firKey, this.fir);
            double scale = 102943.70807283034 / cyclesPerSampleD / Math.PI;
            for (int i = 0; i < this.firRES; ++i) {
                double jPhase = (double)i / (double)this.firRES + (double)(this.firN / 2);
                for (int j = 0; j < this.firN; ++j) {
                    double x = (double)j - jPhase;
                    double xt = x / (double)(this.firN / 2);
                    double kaiserXt = Math.abs(xt) < 1.0 ? SincResampler.I0(beta * Math.sqrt(1.0 - xt * xt)) / I0beta : 0.0;
                    double wt = Math.PI * x / cyclesPerSampleD;
                    double sincWt = Math.abs(wt) >= 1.0E-8 ? Math.sin(wt) / wt : 1.0;
                    this.fir[i][j] = (int)(scale * sincWt * kaiserXt);
                }
            }
        }
    }

    @Override
    public boolean input(int input) {
        boolean ready = false;
        int n = input;
        this.sample[this.sampleIndex + 2048] = n;
        this.sample[this.sampleIndex] = n;
        this.sampleIndex = this.sampleIndex + 1 & 0x7FF;
        if (this.sampleOffset < 1024) {
            this.output = this.fir(this.sampleOffset);
            ready = true;
            this.sampleOffset += this.cyclesPerSample;
        }
        this.sampleOffset -= 1024;
        return ready;
    }

    @Override
    public int output() {
        return this.output;
    }

    @Override
    public void reset() {
        Arrays.fill(this.sample, 0);
        this.sampleOffset = 0;
    }

    private int fir(int subcycle) {
        int firTableFirst = subcycle * this.firRES >> 10;
        int firTableOffset = subcycle * this.firRES & 0x3FF;
        int sampleStart = this.sampleIndex - this.firN + 2048 - 1;
        int v1 = SincResampler.convolve(this.sample, sampleStart, this.fir[firTableFirst]);
        if (++firTableFirst == this.firRES) {
            firTableFirst = 0;
            ++sampleStart;
        }
        int v2 = SincResampler.convolve(this.sample, sampleStart, this.fir[firTableFirst]);
        return v1 + (firTableOffset * (v2 - v1) >> 10);
    }

    public static void main(String[] args) {
        double RATE = 985248.4;
        TwoPassSincResampler r = new TwoPassSincResampler(RATE, 48000.0, 20000.0);
        TreeMap<Double, Double> results = new TreeMap<Double, Double>();
        long start = System.currentTimeMillis();
        for (double freq = 1000.0; freq < RATE / 2.0; freq *= 1.01) {
            int k = 0;
            double omega = Math.PI * 2 * freq / RATE;
            for (int j = 0; j < 2048; ++j) {
                int signal = (int)(32768.0 * Math.sin((double)k++ * omega) * Math.sqrt(2.0));
                r.input(signal);
            }
            int n = 0;
            float pwr = 0.0f;
            for (int j = 0; j < 100000; ++j) {
                int signal;
                if (!r.input(signal = (int)(32768.0 * Math.sin((double)k++ * omega) * Math.sqrt(2.0)))) continue;
                float out = r.output();
                pwr += out * out;
                ++n;
            }
            results.put(freq, 10.0 * Math.log10(pwr / (float)n));
        }
        long end = System.currentTimeMillis();
        for (Map.Entry freq : results.entrySet()) {
            System.out.println(String.format("%6.0f Hz %f dB", freq.getKey(), freq.getValue()));
        }
        System.out.println("Filtering time " + (end - start) + " ms");
    }
}

