/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.IOException;
import java.io.RandomAccessFile;
import libsidplay.components.c1541.DOSErrorCodes;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.GCR;

public final class D64
extends DiskImage {
    private static final int D64_FILE_SIZE_35 = 174848;
    private static final int D64_SECTOR_SIZE = 256;
    private static final int GCR_SECTOR_SIZE_WITH_HEADER = 354;
    private static final int[] GAPS_BETWEEN_SECTORS = new int[]{9, 12, 17, 8};
    private static final int[] SECTOR_MAP_D64 = new int[]{17, 18, 19, 21};
    private byte diskID1;
    private byte diskID2;
    private byte[] errorInfo;

    public D64(GCR gcr, String fileName, RandomAccessFile fd, boolean readOnly) {
        super(gcr, fileName, fd, readOnly);
    }

    @Override
    protected void attach() throws IOException {
        boolean hasErrorinfo;
        int imageBlocks;
        block8: {
            long imageFilesize = this.fd.length();
            this.tracks = 35;
            imageBlocks = 683;
            hasErrorinfo = false;
            do {
                if (imageFilesize == (long)(imageBlocks << 8)) {
                    hasErrorinfo = false;
                    break block8;
                }
                if (imageFilesize == (long)((imageBlocks << 8) + imageBlocks)) {
                    hasErrorinfo = true;
                    break block8;
                }
                imageBlocks += SECTOR_MAP_D64[SPEED_MAP_1541[this.tracks]];
                ++this.tracks;
            } while (this.tracks < 42);
            throw new IOException("Image must be corrupt!");
        }
        this.errorInfo = new byte[imageBlocks];
        if (hasErrorinfo) {
            this.fd.seek(imageBlocks << 8);
            this.fd.readFully(this.errorInfo, 0, imageBlocks);
        }
        byte[] sectorBytes = new byte[256];
        this.readSector(sectorBytes, 0, 18, 0);
        this.diskID1 = sectorBytes[162];
        this.diskID2 = sectorBytes[163];
        for (int track = 1; track <= 42; ++track) {
            this.trackSize[track - 1] = RAW_TRACK_SIZE[SPEED_MAP_1541[track - 1]];
        }
        byte[] gcrSectorBytes = new byte[260];
        block2: for (int track = 1; track <= this.tracks; ++track) {
            int gcrDataPos = (track - 1) * 7928;
            this.gcr.setTrackData(gcrDataPos, 7928, (byte)85);
            int sectorPerTrack = SECTOR_MAP_D64[SPEED_MAP_1541[track - 1]];
            for (int sector = 0; sector < sectorPerTrack; ++sector) {
                DOSErrorCodes errorCode = this.readSector(gcrSectorBytes, 1, track, sector);
                if (errorCode == DOSErrorCodes.CBMDOS_IPE_READ_ERROR_SYNC) {
                    gcrDataPos = (track - 1) * 7928;
                    this.gcr.setTrackData(gcrDataPos, 7928, (byte)0);
                    continue block2;
                }
                this.gcr.convertSectorToGCR(gcrSectorBytes, gcrDataPos, track, sector, this.diskID1, this.diskID2, errorCode);
                gcrDataPos += GAPS_BETWEEN_SECTORS[SPEED_MAP_1541[track - 1]] + 354;
            }
        }
    }

    private DOSErrorCodes readSector(byte[] sectorBytes, int sectorBytesPos, int track, int sector) throws IOException {
        int sectorCount = this.getSectorCount(track, sector);
        this.fd.seek(sectorCount << 8);
        this.fd.readFully(sectorBytes, sectorBytesPos, 256);
        return DOSErrorCodes.valueOf(this.errorInfo[sectorCount]);
    }

    private int getSectorCount(int track, int sector) {
        int sectorCount = sector;
        for (int i = 1; i < track; ++i) {
            sectorCount += SECTOR_MAP_D64[SPEED_MAP_1541[i - 1]];
        }
        return sectorCount;
    }

    @Override
    public void gcrDataWriteback(int track) throws IOException {
        if (track > 40) {
            return;
        }
        int sectorsPerTrack = SECTOR_MAP_D64[SPEED_MAP_1541[track - 1]];
        if (track > this.tracks) {
            if (this.extendImageListener == null || this.extendImageListener.isAllowed()) {
                this.driveExtendDiskImage();
            } else {
                return;
            }
        }
        for (int sector = 0; sector < sectorsPerTrack; ++sector) {
            int gcrDataPos = this.gcr.findSectorHeader(track, sector, this.trackSize[track - 1]);
            if (gcrDataPos == -1) {
                System.err.println(String.format("Could not find header of T:%d S:%d.", track, sector));
                continue;
            }
            if ((gcrDataPos = this.gcr.findSectorData(gcrDataPos, this.trackSize[track - 1])) == -1) {
                System.err.println(String.format("Could not find data sync of T:%d S:%d.", track, sector));
                continue;
            }
            this.gcrDataWritebackSector(gcrDataPos, track, sector);
        }
    }

    private void driveExtendDiskImage() throws IOException {
        byte[] buffer = new byte[256];
        this.tracks = 40;
        for (int tr = 36; tr <= 40; ++tr) {
            int sectorSize = SECTOR_MAP_D64[SPEED_MAP_1541[tr - 1]];
            for (int sec = 0; sec < sectorSize; ++sec) {
                this.writeSector(buffer, 0, tr, sec);
            }
        }
    }

    private void gcrDataWritebackSector(int offset, int track, int sector) throws IOException {
        byte[] sectorBytes = new byte[260];
        this.gcr.convertGCRToSector(sectorBytes, offset, this.trackSize[track - 1]);
        if (sectorBytes[0] != 7) {
            System.err.println(String.format("Could not find data block id of T:%d S:%d.", track, sector));
        } else {
            this.writeSector(sectorBytes, 1, track, sector);
        }
    }

    private void writeSector(byte[] sectorBytes, int sectorBytesPos, int track, int sector) throws IOException {
        int sectorCount = this.getSectorCount(track, sector);
        this.fd.seek(sectorCount << 8);
        this.fd.write(sectorBytes, sectorBytesPos, 256);
    }
}

