/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import builder.resid.ReSIDBase;
import client.teavm.common.oscilloscope.Gauge;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;
import libsidplay.common.SIDEmu;

public class WaveGauge
extends Gauge {
    private int voice;
    private Function<String, String> localizer;

    public WaveGauge(int width, int height, int voice, Function<String, String> localizer, Supplier<ByteBuffer> initGaugeBuffer) {
        super(width, height, initGaugeBuffer);
        this.voice = voice;
        this.localizer = localizer;
    }

    public Gauge sample(SIDEmu sidemu) {
        if (sidemu instanceof ReSIDBase) {
            this.accumulate((float)(((ReSIDBase)sidemu).readOSC(this.voice) & 0xFF) / 255.0f);
        } else {
            this.accumulate(0.0f);
        }
        return this;
    }

    @Override
    public void draw(SIDEmu sidemu) {
        if (sidemu != null) {
            byte wf = sidemu.readInternalRegister(4 + 7 * this.voice);
            byte filt = sidemu.readInternalRegister(23);
            this.text = this.createText(wf, filt);
        }
        super.draw(sidemu);
    }

    private String createText(byte wf, byte filt) {
        StringBuilder result = new StringBuilder();
        result.append(this.localizer.apply("WAV"));
        result.append(" ");
        if ((wf & 0x80) != 0) {
            result.append("8");
        } else {
            result.append(" ");
        }
        if ((wf & 0x40) != 0) {
            result.append("4");
        } else {
            result.append(" ");
        }
        if ((wf & 0x20) != 0) {
            result.append("2");
        } else {
            result.append(" ");
        }
        if ((wf & 0x10) != 0) {
            result.append("1");
        } else {
            result.append(" ");
        }
        if ((wf & 2) != 0) {
            result.append("S");
        } else {
            result.append(" ");
        }
        if ((wf & 4) != 0) {
            result.append("R");
        } else {
            result.append(" ");
        }
        if ((wf & 8) != 0) {
            result.append("T");
        } else {
            result.append(" ");
        }
        if ((filt & 1 << this.voice) != 0) {
            result.append("F");
        } else {
            result.append(" ");
        }
        return result.toString();
    }
}

