/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.util.Random;
import libsidplay.components.c1541.GCR;
import libsidplay.components.c1541.VIA6522DC;

public abstract class Rotation {
    private static final Random RANDOM = new Random();
    protected static final int[] ROT_SPEED_BPC = new int[]{250000, 266667, 285714, 307692};
    private long accum;
    private long rotationLastClk;
    private int bitCounter;
    private int speedZone;
    private int lastReadData;
    private byte lastWriteData;
    private int zeroCount;
    private final GCR gcr = new GCR();

    public final void reset() {
        this.speedZone = 0;
        this.accum = 0L;
        this.bitCounter = 0;
        this.rotationBegins();
        this.gcr.reset();
    }

    protected final void setSpeedZone(int zone) {
        this.speedZone = zone;
    }

    protected final void rotationBegins() {
        this.rotationLastClk = this.cpuClk();
    }

    protected final void rotateDisk() {
        long clk = this.cpuClk();
        this.accum += (long)ROT_SPEED_BPC[this.speedZone] * (clk - this.rotationLastClk);
        this.rotationLastClk = clk;
        int bitsMoved = (int)(this.accum / 1000000L);
        this.accum %= 1000000L;
        if (this.getReadWriteMode() == VIA6522DC.Mode.READ) {
            while (bitsMoved-- != 0) {
                int bit = this.gcr.readNextBit(this.getCurrentTrackSize());
                this.lastReadData = this.lastReadData << 1 & 0x3FE;
                if (bit != 0) {
                    this.zeroCount = 0;
                    this.lastReadData |= 1;
                }
                if (++this.zeroCount > 8 && (this.lastReadData & 0x3F) == 8 && RANDOM.nextInt() > 0x40000000) {
                    this.lastReadData |= 1;
                    if (this.bitCounter < 7 && RANDOM.nextInt() > 0) {
                        ++this.bitCounter;
                        this.lastReadData = this.lastReadData << 1 & 0x3FE;
                    }
                } else if ((this.lastReadData & 0xF) == 0) {
                    this.lastReadData |= 1;
                }
                this.lastWriteData = (byte)(this.lastWriteData << 1);
                if (this.lastReadData == 1023) {
                    this.bitCounter = 0;
                    continue;
                }
                if (++this.bitCounter != 8) continue;
                this.bitCounter = 0;
                this.lastWriteData = (byte)this.lastReadData;
                this.readData((byte)this.lastReadData);
            }
        } else {
            while (bitsMoved-- != 0) {
                this.lastReadData = this.lastReadData << 1 & 0x3FE;
                if ((this.lastReadData & 0xF) == 0) {
                    this.lastReadData |= 1;
                }
                this.setDirty();
                this.gcr.writeNextBit((this.lastWriteData & 0x80) != 0, this.getCurrentTrackSize());
                this.lastWriteData = (byte)(this.lastWriteData << 1);
                if (++this.bitCounter != 8) continue;
                this.bitCounter = 0;
                this.lastWriteData = this.writeData();
            }
        }
    }

    protected final byte syncFound() {
        if (this.getReadWriteMode() == VIA6522DC.Mode.WRITE || this.isDiskChangeInProgress()) {
            return -128;
        }
        return this.lastReadData == 1023 ? (byte)0 : -128;
    }

    protected final GCR getGCR() {
        return this.gcr;
    }

    protected abstract long cpuClk();

    protected abstract VIA6522DC.Mode getReadWriteMode();

    protected abstract void readData(byte var1);

    protected abstract byte writeData();

    protected abstract int getCurrentTrackSize();

    protected abstract void setDirty();

    protected abstract boolean isDiskChangeInProgress();
}

