/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.c1541.VIACore;
import libsidplay.components.iec.IECBus;

public abstract class VIA6522BC
extends VIACore {
    private final IECBus iecbus;
    private IParallelCable parallelCable;
    private int deviceId;

    public final void setParallelCable(IParallelCable cable) {
        this.parallelCable = cable;
    }

    public final IParallelCable getParallelCable() {
        return this.parallelCable;
    }

    public VIA6522BC(int id, IECBus bus) {
        super("1541Drive" + id + "VIA6522BC");
        this.deviceId = id;
        this.iecbus = bus;
    }

    @Override
    public void setCa2(int state) {
    }

    @Override
    public void setCb2(int state) {
    }

    @Override
    public final void storePra(int addr, byte value) {
        this.getParallelCable().driveWrite(value, (this.via[12] & 0xE) == 10, this.deviceId);
    }

    @Override
    public final void storePrb(byte byt) {
        if (byt != this.oldpb) {
            this.iecbus.updateDrive(this.deviceId, byt);
        }
    }

    @Override
    public void storeAcr(byte value) {
    }

    @Override
    public void storeSr(byte value) {
    }

    @Override
    public void storeT2l(byte value) {
    }

    @Override
    public final byte readPra() {
        return (byte)(this.via[1] & this.via[3] | this.getParallelCable().driveRead((this.via[12] & 0xE) == 10) & ~this.via[3]);
    }

    @Override
    public final byte readPrb() {
        byte orval = (byte)((this.deviceId & 0xFFFFFFF7) << 5);
        return (byte)((this.via[0] & 0x1A | this.iecbus.deviceRead()) ^ 0x85 | orval);
    }
}

