/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.supported.core.M93C86;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class GMod2
extends Cartridge {
    protected int currentRomBank;
    protected final byte[][] romlBanks;
    private M93C86 m93c86 = new M93C86();
    private int eeprom_cs = 0;
    private int eeprom_data = 0;
    private int eeprom_clock = 0;
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            if (GMod2.this.eeprom_cs != 0) {
                return (byte)(GMod2.this.m93c86.m93c86_read_data() << 7 | GMod2.this.pla.getDisconnectedBusBank().read(address) & 0x7F);
            }
            return 0;
        }

        @Override
        public void write(int address, byte value) {
            if (address == 56832) {
                if ((value & 0x40) != 0 && (value & 0x80) != 0) {
                    GMod2.this.pla.setGameExrom(true, true, true, false);
                } else {
                    GMod2.this.pla.setGameExrom(true, (value & 0x80) != 0);
                }
                GMod2.this.currentRomBank = value & 0x3F;
                GMod2.this.eeprom_cs = value >> 6 & 1;
                GMod2.this.eeprom_data = value >> 4 & 1;
                GMod2.this.eeprom_clock = value >> 5 & 1;
                GMod2.this.m93c86.m93c86_write_select(GMod2.this.eeprom_cs);
                if (GMod2.this.eeprom_cs != 0) {
                    GMod2.this.m93c86.m93c86_write_data(GMod2.this.eeprom_data);
                    GMod2.this.m93c86.m93c86_write_clock(GMod2.this.eeprom_clock);
                }
            }
        }
    };
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return GMod2.this.romlBanks[GMod2.this.currentRomBank][address & 0x1FFF];
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return GMod2.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            GMod2.this.romlBanks[GMod2.this.currentRomBank][address & 0x1FFF] = value;
        }
    };

    public GMod2(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romlBanks = new byte[64][];
        for (int i = 0; i < 64 && dis.available() > 0; ++i) {
            this.romlBanks[i] = new byte[8192];
            dis.readFully(chipHeader);
            if (chipHeader[11] >= 64 || (chipHeader[12] & 0xFF) != 128 && (chipHeader[12] & 0xFF) != 160) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romlBanks[bank]);
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.eeprom_cs = 0;
        this.m93c86.m93c86_write_select(this.eeprom_cs);
        this.io1Bank.write(56832, (byte)0);
        this.pla.setGameExrom(true, false);
    }
}

