/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Zaxxon
extends Cartridge {
    protected final byte[] roml;
    protected final byte[][] romh;
    protected byte[] romhActive;
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            Zaxxon.this.romhActive = Zaxxon.this.romh[(address & 0x1000) >> 12];
            return Zaxxon.this.roml[address & 0xFFF];
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return Zaxxon.this.romhActive[address & 0x1FFF];
        }
    };

    public Zaxxon(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        dis.readFully(chipHeader);
        if (chipHeader[12] != -128 || chipHeader[14] != 16 && chipHeader[14] != 32) {
            throw new IOException("Unexpected Chip header!");
        }
        int bankLen = (chipHeader[14] & 0xFF) << 8;
        this.roml = new byte[bankLen];
        dis.readFully(this.roml);
        this.romh = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            this.romh[i] = new byte[8192];
            dis.readFully(chipHeader);
            if (chipHeader[12] != -96 || chipHeader[14] != 32) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            byte bankNum = chipHeader[11];
            dis.readFully(this.romh[bankNum]);
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public void reset() {
        super.reset();
        this.romlBank.read(32768);
        this.pla.setGameExrom(false, false);
    }
}

